/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.zhipu.Json;
import dev.langchain4j.model.zhipu.ZhipuAiException;
import dev.langchain4j.model.zhipu.chat.AssistantMessage;
import dev.langchain4j.model.zhipu.chat.ChatCompletionChoice;
import dev.langchain4j.model.zhipu.chat.ChatCompletionRequest;
import dev.langchain4j.model.zhipu.chat.ChatCompletionResponse;
import dev.langchain4j.model.zhipu.chat.Content;
import dev.langchain4j.model.zhipu.chat.Function;
import dev.langchain4j.model.zhipu.chat.FunctionCall;
import dev.langchain4j.model.zhipu.chat.Image;
import dev.langchain4j.model.zhipu.chat.ImageContent;
import dev.langchain4j.model.zhipu.chat.Message;
import dev.langchain4j.model.zhipu.chat.Parameters;
import dev.langchain4j.model.zhipu.chat.SystemMessage;
import dev.langchain4j.model.zhipu.chat.TextContent;
import dev.langchain4j.model.zhipu.chat.Tool;
import dev.langchain4j.model.zhipu.chat.ToolCall;
import dev.langchain4j.model.zhipu.chat.ToolMessage;
import dev.langchain4j.model.zhipu.chat.ToolType;
import dev.langchain4j.model.zhipu.chat.UserMessage;
import dev.langchain4j.model.zhipu.embedding.EmbeddingResponse;
import dev.langchain4j.model.zhipu.shared.ErrorResponse;
import dev.langchain4j.model.zhipu.shared.Usage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.ResponseBody;

class DefaultZhipuAiHelper {
    static final String FINISH_REASON_SENSITIVE = "sensitive";
    static final String FINISH_REASON_OTHER = "other";

    DefaultZhipuAiHelper() {
    }

    static List<Embedding> toEmbed(List<EmbeddingResponse> response) {
        return response.stream().map(zhipuAiEmbedding -> Embedding.from(zhipuAiEmbedding.getEmbedding())).collect(Collectors.toList());
    }

    static List<Tool> toTools(List<ToolSpecification> toolSpecifications) {
        return toolSpecifications.stream().map(toolSpecification -> Tool.from(DefaultZhipuAiHelper.toFunction(toolSpecification))).collect(Collectors.toList());
    }

    private static Function toFunction(ToolSpecification toolSpecification) {
        return Function.builder().name(toolSpecification.name()).description(toolSpecification.description()).parameters(DefaultZhipuAiHelper.toFunctionParameters(toolSpecification.parameters())).build();
    }

    private static Parameters toFunctionParameters(ToolParameters toolParameters) {
        if (toolParameters == null) {
            return Parameters.builder().build();
        }
        return Parameters.builder().properties(toolParameters.properties()).required(toolParameters.required()).build();
    }

    static List<Message> toZhipuAiMessages(List<ChatMessage> messages) {
        return messages.stream().map(DefaultZhipuAiHelper::toZhipuAiMessage).collect(Collectors.toList());
    }

    private static Message toZhipuAiMessage(ChatMessage message) {
        if (message instanceof dev.langchain4j.data.message.SystemMessage) {
            dev.langchain4j.data.message.SystemMessage systemMessage = (dev.langchain4j.data.message.SystemMessage)message;
            return SystemMessage.builder().content(systemMessage.text()).build();
        }
        if (message instanceof dev.langchain4j.data.message.UserMessage) {
            dev.langchain4j.data.message.UserMessage userMessage = (dev.langchain4j.data.message.UserMessage)message;
            if (userMessage.hasSingleText()) {
                return UserMessage.from(userMessage.singleText());
            }
            ArrayList<Content> contents = new ArrayList<Content>(userMessage.contents().size());
            userMessage.contents().forEach(content -> {
                if (content instanceof dev.langchain4j.data.message.TextContent) {
                    dev.langchain4j.data.message.TextContent textContent = (dev.langchain4j.data.message.TextContent)content;
                    contents.add(TextContent.builder().text(textContent.text()).build());
                }
                if (content instanceof dev.langchain4j.data.message.ImageContent) {
                    dev.langchain4j.data.image.Image image = ((dev.langchain4j.data.message.ImageContent)content).image();
                    contents.add(ImageContent.builder().imageUrl(Image.builder().url(image.url() != null ? image.url().toString() : image.base64Data()).build()).build());
                }
            });
            return UserMessage.from(contents);
        }
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            if (!aiMessage.hasToolExecutionRequests()) {
                return AssistantMessage.builder().content(aiMessage.text()).build();
            }
            ArrayList<ToolCall> toolCallArrayList = new ArrayList<ToolCall>();
            for (ToolExecutionRequest executionRequest : aiMessage.toolExecutionRequests()) {
                toolCallArrayList.add(ToolCall.builder().function(FunctionCall.builder().name(executionRequest.name()).arguments(executionRequest.arguments()).build()).type(ToolType.FUNCTION).id(executionRequest.id()).build());
            }
            return AssistantMessage.builder().content(aiMessage.text()).toolCalls(toolCallArrayList).build();
        }
        if (message instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage resultMessage = (ToolExecutionResultMessage)message;
            return ToolMessage.builder().content(resultMessage.text()).build();
        }
        throw Exceptions.illegalArgument((String)("Unknown message type: " + message.type()), (Object[])new Object[0]);
    }

    static AiMessage aiMessageFrom(ChatCompletionResponse response) {
        AssistantMessage message = response.getChoices().get(0).getMessage();
        if (Utils.isNullOrEmpty(message.getToolCalls())) {
            return AiMessage.from((String)message.getContent());
        }
        return AiMessage.from(DefaultZhipuAiHelper.specificationsFrom(message.getToolCalls()));
    }

    static List<ToolExecutionRequest> specificationsFrom(List<ToolCall> toolCalls) {
        ArrayList<ToolExecutionRequest> specifications = new ArrayList<ToolExecutionRequest>(toolCalls.size());
        for (ToolCall toolCall : toolCalls) {
            specifications.add(ToolExecutionRequest.builder().id(toolCall.getId()).name(toolCall.getFunction().getName()).arguments(toolCall.getFunction().getArguments()).build());
        }
        return specifications;
    }

    static Usage getEmbeddingUsage(List<EmbeddingResponse> responses) {
        Usage tokenUsage = Usage.builder().completionTokens(0).promptTokens(0).totalTokens(0).build();
        for (EmbeddingResponse response : responses) {
            tokenUsage.add(response.getUsage());
        }
        return tokenUsage;
    }

    static TokenUsage tokenUsageFrom(Usage zhipuUsage) {
        if (zhipuUsage == null) {
            return null;
        }
        return new TokenUsage(zhipuUsage.getPromptTokens(), zhipuUsage.getCompletionTokens(), zhipuUsage.getTotalTokens());
    }

    static ChatCompletionResponse toChatErrorResponse(Object object) {
        return ChatCompletionResponse.builder().choices(Collections.singletonList(DefaultZhipuAiHelper.toChatErrorChoice(object))).usage(Usage.builder().build()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ChatCompletionChoice toChatErrorChoice(Object object) {
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            return ChatCompletionChoice.builder().message(AssistantMessage.builder().content(throwable.getMessage()).build()).finishReason(FINISH_REASON_OTHER).build();
        }
        ResponseBody errorBody = ((retrofit2.Response)object).errorBody();
        if (errorBody == null) {
            return ChatCompletionChoice.builder().finishReason(FINISH_REASON_OTHER).build();
        }
        try {
            ErrorResponse errorResponse = Json.fromJson(errorBody.string(), ErrorResponse.class);
            String code = errorResponse.getError().get("code");
            ChatCompletionChoice chatCompletionChoice = ChatCompletionChoice.builder().message(AssistantMessage.builder().content(errorResponse.getError().get("message")).build()).finishReason(DefaultZhipuAiHelper.getFinishReason(code)).build();
            return chatCompletionChoice;
        }
        catch (IOException e) {
            ChatCompletionChoice chatCompletionChoice = ChatCompletionChoice.builder().message(AssistantMessage.builder().content(e.getMessage()).build()).finishReason(FINISH_REASON_OTHER).build();
            return chatCompletionChoice;
        }
        finally {
            errorBody.close();
        }
    }

    static String getFinishReason(Object o) {
        ZhipuAiException exception;
        if (o instanceof String && "1301".equals(o)) {
            return FINISH_REASON_SENSITIVE;
        }
        if (o instanceof ZhipuAiException && "1301".equals((exception = (ZhipuAiException)o).getCode())) {
            return FINISH_REASON_SENSITIVE;
        }
        return FINISH_REASON_OTHER;
    }

    static ChatModelRequest createModelListenerRequest(ChatCompletionRequest options, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        return ChatModelRequest.builder().model(options.getModel()).temperature(options.getTemperature()).topP(options.getTopP()).maxTokens(options.getMaxTokens()).messages(messages).toolSpecifications(toolSpecifications).build();
    }

    static ChatModelResponse createModelListenerResponse(String responseId, String responseModel, Response<AiMessage> response) {
        if (response == null) {
            return null;
        }
        return ChatModelResponse.builder().id(responseId).model(responseModel).tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).aiMessage((AiMessage)response.content()).build();
    }

    static boolean isSuccessFinishReason(FinishReason finishReason) {
        return !FinishReason.CONTENT_FILTER.equals((Object)finishReason) && !FinishReason.OTHER.equals((Object)finishReason);
    }

    static FinishReason finishReasonFrom(String finishReason) {
        if (finishReason == null) {
            return null;
        }
        switch (finishReason) {
            case "stop": {
                return FinishReason.STOP;
            }
            case "length": {
                return FinishReason.LENGTH;
            }
            case "tool_calls": {
                return FinishReason.TOOL_EXECUTION;
            }
            case "sensitive": {
                return FinishReason.CONTENT_FILTER;
            }
        }
        return FinishReason.OTHER;
    }
}

