/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shiro.util.ThreadContext;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.config.mqtoken.UserTokenContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ThreadPoolConfig {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolConfig.class);

    @Bean(name={"threadPoolExecutor"})
    public ThreadPoolExecutor myThreadPool() {
        return new ThreadPoolExecutor(300, 300, 30L, TimeUnit.MINUTES, new LinkedBlockingQueue(), new NamedThreadFactory("AsyncTask"), new ThreadPoolExecutor.AbortPolicy()){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                log.info("\u5df2\u9000\u51fa\u5f02\u6b65\u7ebf\u7a0b\uff0c\u6b63\u5728\u6e05\u7406\u7ebf\u7a0b\u6c60\u53d8\u91cf");
                TenantContext.clear();
                ThreadContext.unbindSubject();
                UserTokenContext.remove();
                log.info("\u5df2\u9000\u51fa\u5f02\u6b65\u7ebf\u7a0b\uff0c\u5df2\u6e05\u7406\u79df\u6237\u548c\u5f53\u524d\u767b\u9646\u8005\u4fe1\u606f");
            }

            @Override
            protected void beforeExecute(Thread t, Runnable r) {
            }
        };
    }

    class NamedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup threadGroup;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        public final String namePrefix;

        NamedThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            ThreadGroup threadGroup = this.threadGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            if (null == name || "".equals(name.trim())) {
                name = "pool";
            }
            this.namePrefix = name + "-" + this.poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.threadGroup, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

