/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.shiro.ignore;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jeecg.config.shiro.IgnoreAuth;
import org.jeecg.config.shiro.ignore.InMemoryIgnoreAuth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class IgnoreAuthPostProcessor
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(IgnoreAuthPostProcessor.class);
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    public void afterPropertiesSet() throws Exception {
        long startTime = System.currentTimeMillis();
        ArrayList<String> ignoreAuthUrls = new ArrayList<String>();
        Set restControllers = this.requestMappingHandlerMapping.getHandlerMethods().values().stream().map(HandlerMethod::getBeanType).collect(Collectors.toSet());
        for (Class restController : restControllers) {
            ignoreAuthUrls.addAll(this.postProcessRestController(restController));
        }
        log.info("Init Token ignoreAuthUrls Config [ \u96c6\u5408 ]  \uff1a{}", ignoreAuthUrls);
        if (!CollectionUtils.isEmpty(ignoreAuthUrls)) {
            InMemoryIgnoreAuth.set(ignoreAuthUrls);
        }
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        log.info("Init Token ignoreAuthUrls Config [ \u8017\u65f6 ] \uff1a" + elapsedTime + "\u6beb\u79d2");
    }

    private List<String> postProcessRestController(Class<?> clazz) {
        Method[] methods;
        ArrayList<String> ignoreAuthUrls = new ArrayList<String>();
        RequestMapping base = clazz.getAnnotation(RequestMapping.class);
        String[] baseUrl = Objects.nonNull(base) ? base.value() : new String[]{};
        for (Method method : methods = clazz.getDeclaredMethods()) {
            String[] uri;
            RequestMapping requestMapping;
            if (method.isAnnotationPresent(IgnoreAuth.class) && method.isAnnotationPresent(RequestMapping.class)) {
                requestMapping = method.getAnnotation(RequestMapping.class);
                uri = requestMapping.value();
                ignoreAuthUrls.addAll(this.rebuildUrl(baseUrl, uri));
                continue;
            }
            if (method.isAnnotationPresent(IgnoreAuth.class) && method.isAnnotationPresent(GetMapping.class)) {
                requestMapping = method.getAnnotation(GetMapping.class);
                uri = requestMapping.value();
                ignoreAuthUrls.addAll(this.rebuildUrl(baseUrl, uri));
                continue;
            }
            if (method.isAnnotationPresent(IgnoreAuth.class) && method.isAnnotationPresent(PostMapping.class)) {
                requestMapping = method.getAnnotation(PostMapping.class);
                uri = requestMapping.value();
                ignoreAuthUrls.addAll(this.rebuildUrl(baseUrl, uri));
                continue;
            }
            if (method.isAnnotationPresent(IgnoreAuth.class) && method.isAnnotationPresent(PutMapping.class)) {
                requestMapping = method.getAnnotation(PutMapping.class);
                uri = requestMapping.value();
                ignoreAuthUrls.addAll(this.rebuildUrl(baseUrl, uri));
                continue;
            }
            if (method.isAnnotationPresent(IgnoreAuth.class) && method.isAnnotationPresent(DeleteMapping.class)) {
                requestMapping = method.getAnnotation(DeleteMapping.class);
                uri = requestMapping.value();
                ignoreAuthUrls.addAll(this.rebuildUrl(baseUrl, uri));
                continue;
            }
            if (!method.isAnnotationPresent(IgnoreAuth.class) || !method.isAnnotationPresent(PatchMapping.class)) continue;
            requestMapping = method.getAnnotation(PatchMapping.class);
            uri = requestMapping.value();
            ignoreAuthUrls.addAll(this.rebuildUrl(baseUrl, uri));
        }
        return ignoreAuthUrls;
    }

    private List<String> rebuildUrl(String[] bases, String[] uris) {
        ArrayList<String> urls = new ArrayList<String>();
        if (bases.length > 0) {
            for (String base : bases) {
                for (String uri2 : uris) {
                    urls.add(this.prefix(base) + this.prefix(uri2));
                }
            }
        } else {
            Arrays.stream(uris).forEach(uri -> urls.add(this.prefix((String)uri)));
        }
        return urls;
    }

    private String prefix(String seg) {
        return seg.startsWith("/") ? seg : "/" + seg;
    }

    public IgnoreAuthPostProcessor(RequestMappingHandlerMapping requestMappingHandlerMapping) {
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }
}

