/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.enhancements.annotations.aspect;

import cn.hutool.core.util.StrUtil;
import jakarta.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.enhancements.annotations.HandleBindingData;
import org.jeecg.enhancements.modules.general.service.ISysGeneralService;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class HandleBindingDataAspect {
    @Resource
    private ISysGeneralService sysGeneralService;

    @Around(value="@annotation(handleBindingData)")
    public Object aroundMethodExecution(ProceedingJoinPoint joinPoint, HandleBindingData handleBindingData) throws Throwable {
        String value = handleBindingData.value();
        String configName = handleBindingData.configName();
        String entityName = handleBindingData.entityName();
        if (configName.isEmpty()) {
            configName = value;
        }
        if (entityName.isEmpty()) {
            entityName = value;
        }
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String[] parameterNames = methodSignature.getParameterNames();
        int entityNameIndex = -1;
        for (int i = 0; i < parameterNames.length; ++i) {
            if (!parameterNames[i].equals(StrUtil.toCamelCase((CharSequence)entityName))) continue;
            entityNameIndex = i;
            break;
        }
        if (entityNameIndex == -1) {
            throw new JeecgBootException("Method parameter " + entityName + " not found");
        }
        Object[] args = joinPoint.getArgs();
        Object entity = args[entityNameIndex];
        this.sysGeneralService.setNewBinding(configName, entity);
        return joinPoint.proceed();
    }
}

