/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.loader;

import io.seata.common.Constants;
import io.seata.common.executor.Initialize;
import io.seata.common.loader.EnhancedServiceNotFoundException;
import io.seata.common.loader.ExtensionDefinition;
import io.seata.common.loader.LoadLevel;
import io.seata.common.loader.Scope;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedServiceLoader {
    private static final ConcurrentMap<Class<?>, InnerEnhancedServiceLoader<?>> SERVICE_LOADERS = new ConcurrentHashMap();

    public static <S> S load(Class<S> service, ClassLoader loader) throws EnhancedServiceNotFoundException {
        return (S)((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(service)).load(loader);
    }

    public static <S> S load(Class<S> service) throws EnhancedServiceNotFoundException {
        return (S)((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(service)).load(EnhancedServiceLoader.findClassLoader());
    }

    public static <S> S load(Class<S> service, String activateName) throws EnhancedServiceNotFoundException {
        return (S)((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(service)).load(activateName, EnhancedServiceLoader.findClassLoader());
    }

    public static <S> S load(Class<S> service, String activateName, ClassLoader loader) throws EnhancedServiceNotFoundException {
        return (S)((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(service)).load(activateName, loader);
    }

    public static <S> S load(Class<S> service, String activateName, Object[] args) throws EnhancedServiceNotFoundException {
        return (S)((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(service)).load(activateName, args, EnhancedServiceLoader.findClassLoader());
    }

    public static <S> S load(Class<S> service, String activateName, Class<?>[] argsType, Object[] args) throws EnhancedServiceNotFoundException {
        return (S)((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(service)).load(activateName, argsType, args, EnhancedServiceLoader.findClassLoader());
    }

    public static <S> List<S> loadAll(Class<S> service) {
        return ((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(service)).loadAll(EnhancedServiceLoader.findClassLoader());
    }

    public static <S> List<S> loadAll(Class<S> service, Class<?>[] argsType, Object[] args) {
        return ((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(service)).loadAll(argsType, args, EnhancedServiceLoader.findClassLoader());
    }

    public static void unloadAll() {
        InnerEnhancedServiceLoader.removeAllServiceLoader();
    }

    public static <S> void unload(Class<S> service) {
        InnerEnhancedServiceLoader.removeServiceLoader(service);
    }

    public static <S> void unload(Class<S> service, String activateName) {
        if (activateName == null) {
            throw new IllegalArgumentException("activateName is null");
        }
        InnerEnhancedServiceLoader serviceLoader = InnerEnhancedServiceLoader.getServiceLoader(service);
        ConcurrentMap classToDefinitionMap = serviceLoader.classToDefinitionMap;
        ArrayList extensionDefinitions = new ArrayList();
        for (Map.Entry entry : classToDefinitionMap.entrySet()) {
            String name = ((ExtensionDefinition)entry.getValue()).getName();
            if (null == name || !name.equals(activateName)) continue;
            extensionDefinitions.add(entry.getValue());
            classToDefinitionMap.remove(entry.getKey());
        }
        serviceLoader.nameToDefinitionsMap.remove(activateName);
        if (CollectionUtils.isNotEmpty(extensionDefinitions)) {
            for (ExtensionDefinition definition : extensionDefinitions) {
                serviceLoader.definitionToInstanceMap.remove(definition);
            }
        }
    }

    static <S> List<Class<S>> getAllExtensionClass(Class<S> service) {
        return ((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(service)).getAllExtensionClass(EnhancedServiceLoader.findClassLoader());
    }

    static <S> List<Class<S>> getAllExtensionClass(Class<S> service, ClassLoader loader) {
        return ((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(service)).getAllExtensionClass(loader);
    }

    private static ClassLoader findClassLoader() {
        return EnhancedServiceLoader.class.getClassLoader();
    }

    private static class InnerEnhancedServiceLoader<S> {
        private static final Logger LOGGER = LoggerFactory.getLogger(InnerEnhancedServiceLoader.class);
        private static final String SERVICES_DIRECTORY = "META-INF/services/";
        private static final String SEATA_DIRECTORY = "META-INF/seata/";
        private final Class<S> type;
        private final Holder<List<ExtensionDefinition<S>>> definitionsHolder = new Holder();
        private final ConcurrentMap<ExtensionDefinition<S>, Holder<Object>> definitionToInstanceMap = new ConcurrentHashMap<ExtensionDefinition<S>, Holder<Object>>();
        private final ConcurrentMap<String, List<ExtensionDefinition<S>>> nameToDefinitionsMap = new ConcurrentHashMap<String, List<ExtensionDefinition<S>>>();
        private final ConcurrentMap<Class<?>, ExtensionDefinition<S>> classToDefinitionMap = new ConcurrentHashMap();

        private InnerEnhancedServiceLoader(Class<S> type) {
            this.type = type;
        }

        private static <S> InnerEnhancedServiceLoader<S> getServiceLoader(Class<S> type) {
            if (type == null) {
                throw new IllegalArgumentException("Enhanced Service type is null");
            }
            return CollectionUtils.computeIfAbsent(SERVICE_LOADERS, type, key -> new InnerEnhancedServiceLoader(type));
        }

        private static <S> InnerEnhancedServiceLoader<S> removeServiceLoader(Class<S> type) {
            if (type == null) {
                throw new IllegalArgumentException("Enhanced Service type is null");
            }
            return (InnerEnhancedServiceLoader)SERVICE_LOADERS.remove(type);
        }

        private static void removeAllServiceLoader() {
            SERVICE_LOADERS.clear();
        }

        private S load(ClassLoader loader) throws EnhancedServiceNotFoundException {
            return this.loadExtension(loader, null, null);
        }

        private S load(String activateName, ClassLoader loader) throws EnhancedServiceNotFoundException {
            return this.loadExtension(activateName, loader, null, null);
        }

        private S load(String activateName, Object[] args, ClassLoader loader) throws EnhancedServiceNotFoundException {
            Class[] argsType = null;
            if (args != null && args.length > 0) {
                argsType = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    argsType[i] = args[i].getClass();
                }
            }
            return this.loadExtension(activateName, loader, argsType, args);
        }

        private S load(String activateName, Class<?>[] argsType, Object[] args, ClassLoader loader) throws EnhancedServiceNotFoundException {
            return this.loadExtension(activateName, loader, argsType, args);
        }

        private List<S> loadAll(ClassLoader loader) {
            return this.loadAll(null, null, loader);
        }

        private List<S> loadAll(Class<?>[] argsType, Object[] args, ClassLoader loader) {
            ArrayList<S> allInstances = new ArrayList<S>();
            List<Class<S>> allClazzs = this.getAllExtensionClass(loader);
            if (CollectionUtils.isEmpty(allClazzs)) {
                return allInstances;
            }
            try {
                for (Class<S> clazz : allClazzs) {
                    ExtensionDefinition definition = (ExtensionDefinition)this.classToDefinitionMap.get(clazz);
                    allInstances.add(this.getExtensionInstance(definition, loader, argsType, args));
                }
            }
            catch (Throwable t) {
                throw new EnhancedServiceNotFoundException(t);
            }
            return allInstances;
        }

        private List<Class<S>> getAllExtensionClass(ClassLoader loader) {
            return this.loadAllExtensionClass(loader);
        }

        private S loadExtension(ClassLoader loader, Class<?>[] argTypes, Object[] args) {
            try {
                this.loadAllExtensionClass(loader);
                ExtensionDefinition<S> defaultExtensionDefinition = this.getDefaultExtensionDefinition();
                return this.getExtensionInstance(defaultExtensionDefinition, loader, argTypes, args);
            }
            catch (EnhancedServiceNotFoundException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new EnhancedServiceNotFoundException("not found service provider for : " + this.type.getName() + " caused by " + ExceptionUtils.getFullStackTrace((Throwable)e));
            }
        }

        private S loadExtension(String activateName, ClassLoader loader, Class[] argTypes, Object[] args) {
            if (StringUtils.isEmpty(activateName)) {
                throw new IllegalArgumentException("the name of service provider for [" + this.type.getName() + "] name is null");
            }
            try {
                this.loadAllExtensionClass(loader);
                ExtensionDefinition<S> cachedExtensionDefinition = this.getCachedExtensionDefinition(activateName);
                return this.getExtensionInstance(cachedExtensionDefinition, loader, argTypes, args);
            }
            catch (Throwable e) {
                if (e instanceof EnhancedServiceNotFoundException) {
                    throw (EnhancedServiceNotFoundException)((Object)e);
                }
                throw new EnhancedServiceNotFoundException("not found service provider for : " + this.type.getName() + " caused by " + ExceptionUtils.getFullStackTrace((Throwable)e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private S getExtensionInstance(ExtensionDefinition<S> definition, ClassLoader loader, Class<?>[] argTypes, Object[] args) {
            if (definition == null) {
                throw new EnhancedServiceNotFoundException("not found service provider for : " + this.type.getName());
            }
            if (Scope.SINGLETON.equals((Object)definition.getScope())) {
                Holder holder = CollectionUtils.computeIfAbsent(this.definitionToInstanceMap, definition, key -> new Holder());
                Object instance = holder.get();
                if (instance == null) {
                    Holder holder2 = holder;
                    synchronized (holder2) {
                        instance = holder.get();
                        if (instance == null) {
                            instance = this.createNewExtension(definition, loader, argTypes, args);
                            holder.set(instance);
                        }
                    }
                }
                return (S)instance;
            }
            return this.createNewExtension(definition, loader, argTypes, args);
        }

        private S createNewExtension(ExtensionDefinition<S> definition, ClassLoader loader, Class<?>[] argTypes, Object[] args) {
            Class<S> clazz = definition.getServiceClass();
            try {
                return this.initInstance(clazz, argTypes, args);
            }
            catch (Throwable t) {
                throw new IllegalStateException("Extension instance(definition: " + definition + ", class: " + this.type + ")  could not be instantiated: " + t.getMessage(), t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Class<S>> loadAllExtensionClass(ClassLoader loader) {
            List<ExtensionDefinition<S>> definitions = (List<ExtensionDefinition<S>>)((Holder)this.definitionsHolder).get();
            if (definitions == null) {
                Holder<List<ExtensionDefinition<S>>> holder = this.definitionsHolder;
                synchronized (holder) {
                    definitions = (List)((Holder)this.definitionsHolder).get();
                    if (definitions == null) {
                        definitions = this.findAllExtensionDefinition(loader);
                        ((Holder)this.definitionsHolder).set(definitions);
                    }
                }
            }
            return definitions.stream().map(ExtensionDefinition::getServiceClass).collect(Collectors.toList());
        }

        private List<ExtensionDefinition<S>> findAllExtensionDefinition(ClassLoader loader) {
            ArrayList<ExtensionDefinition<S>> extensionDefinitions = new ArrayList<ExtensionDefinition<S>>();
            try {
                this.loadFile(SERVICES_DIRECTORY, loader, extensionDefinitions);
                this.loadFile(SEATA_DIRECTORY, loader, extensionDefinitions);
            }
            catch (IOException e) {
                throw new EnhancedServiceNotFoundException(e);
            }
            if (!this.nameToDefinitionsMap.isEmpty()) {
                for (List definitions : this.nameToDefinitionsMap.values()) {
                    definitions.sort((def1, def2) -> {
                        int o1 = def1.getOrder();
                        int o2 = def2.getOrder();
                        return Integer.compare(o1, o2);
                    });
                }
            }
            if (!extensionDefinitions.isEmpty()) {
                extensionDefinitions.sort((def1, def2) -> {
                    int o1 = def1.getOrder();
                    int o2 = def2.getOrder();
                    return Integer.compare(o1, o2);
                });
            }
            return extensionDefinitions;
        }

        private void loadFile(String dir, ClassLoader loader, List<ExtensionDefinition<S>> extensions) throws IOException {
            String fileName = dir + this.type.getName();
            Enumeration<URL> urls = loader != null ? loader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (urls != null) {
                boolean hasServiceFile = false;
                boolean hasClasses = false;
                block14: while (urls.hasMoreElements()) {
                    hasServiceFile = true;
                    URL url = urls.nextElement();
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), Constants.DEFAULT_CHARSET));
                        Throwable throwable = null;
                        block15: while (true) {
                            try {
                                String line;
                                while ((line = reader.readLine()) != null) {
                                    int ci = line.indexOf(35);
                                    if (ci >= 0) {
                                        line = line.substring(0, ci);
                                    }
                                    if ((line = line.trim()).length() <= 0) continue;
                                    hasClasses = true;
                                    try {
                                        ExtensionDefinition<S> extensionDefinition = this.getUnloadedExtensionDefinition(line, loader);
                                        if (extensionDefinition == null) {
                                            if (!LOGGER.isDebugEnabled()) continue block15;
                                            LOGGER.debug("The same extension {} has already been loaded, skipped", (Object)line);
                                            continue;
                                        }
                                        extensions.add(extensionDefinition);
                                        continue block15;
                                    }
                                    catch (ClassNotFoundException | LinkageError e) {
                                        LOGGER.warn("Load [{}] class fail: {}", (Object)line, (Object)e.getMessage());
                                    }
                                    catch (ClassCastException e) {
                                        LOGGER.error("Load [{}] class fail, please make sure the extension config in {} implements {}.", new Object[]{line, fileName, this.type.getName()});
                                    }
                                }
                                continue block14;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.warn("load class instance error:", e);
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    if (!hasServiceFile) {
                        LOGGER.warn("Load [{}] class fail: no service files found in '{}'.", (Object)this.type.getName(), (Object)dir);
                    } else if (!hasClasses) {
                        LOGGER.warn("Load [{}] class fail: the service files in '{}' is all empty.", (Object)this.type.getName(), (Object)dir);
                    }
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.warn("Load [{}] class fail: no urls found in '{}'.", (Object)this.type.getName(), (Object)dir);
            }
        }

        private ExtensionDefinition<S> getUnloadedExtensionDefinition(String className, ClassLoader loader) throws ClassNotFoundException, ClassCastException {
            if (!this.isDefinitionContainsClazz(className, loader)) {
                Class<?> clazz = Class.forName(className, true, loader);
                if (!this.type.isAssignableFrom(clazz)) {
                    LOGGER.error("can't cast {} to {}", (Object)clazz.getName(), (Object)this.type.getName());
                    throw new ClassCastException();
                }
                Class<?> enhancedServiceClass = clazz;
                String serviceName = null;
                int priority = 0;
                Scope scope = Scope.SINGLETON;
                LoadLevel loadLevel = clazz.getAnnotation(LoadLevel.class);
                if (loadLevel != null) {
                    serviceName = loadLevel.name();
                    priority = loadLevel.order();
                    scope = loadLevel.scope();
                }
                ExtensionDefinition result = new ExtensionDefinition(serviceName, priority, scope, enhancedServiceClass);
                this.classToDefinitionMap.put(clazz, result);
                if (serviceName != null) {
                    CollectionUtils.computeIfAbsent(this.nameToDefinitionsMap, serviceName, e -> new ArrayList()).add(result);
                }
                return result;
            }
            return null;
        }

        private boolean isDefinitionContainsClazz(String className, ClassLoader loader) {
            for (Map.Entry entry : this.classToDefinitionMap.entrySet()) {
                if (!((Class)entry.getKey()).getName().equals(className) || !Objects.equals(((ExtensionDefinition)entry.getValue()).getServiceClass().getClassLoader(), loader)) continue;
                return true;
            }
            return false;
        }

        private ExtensionDefinition<S> getDefaultExtensionDefinition() {
            List currentDefinitions = (List)((Holder)this.definitionsHolder).get();
            return (ExtensionDefinition)CollectionUtils.getLast(currentDefinitions);
        }

        private ExtensionDefinition<S> getCachedExtensionDefinition(String activateName) {
            List definitions = (List)this.nameToDefinitionsMap.get(activateName);
            return (ExtensionDefinition)CollectionUtils.getLast(definitions);
        }

        private S initInstance(Class<S> implClazz, Class<?>[] argTypes, Object[] args) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
            S s = null;
            if (argTypes != null && args != null) {
                Constructor<S> constructor = implClazz.getDeclaredConstructor(argTypes);
                s = this.type.cast(constructor.newInstance(args));
            } else {
                s = this.type.cast(implClazz.newInstance());
            }
            if (s instanceof Initialize) {
                ((Initialize)s).init();
            }
            return s;
        }

        private static class Holder<T> {
            private volatile T value;

            private Holder() {
            }

            private void set(T value) {
                this.value = value;
            }

            private T get() {
                return this.value;
            }
        }
    }
}

