/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi.svg;

import net.arnx.wmf2svg.gdi.Point;
import net.arnx.wmf2svg.gdi.Size;
import net.arnx.wmf2svg.gdi.svg.SvgBrush;
import net.arnx.wmf2svg.gdi.svg.SvgFont;
import net.arnx.wmf2svg.gdi.svg.SvgGdi;
import net.arnx.wmf2svg.gdi.svg.SvgPen;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgDc
implements Cloneable {
    private SvgGdi gdi;
    private int dpi = 1440;
    private int wx = 0;
    private int wy = 0;
    private int ww = 0;
    private int wh = 0;
    private int wox = 0;
    private int woy = 0;
    private double wsx = 1.0;
    private double wsy = 1.0;
    private double mx = 1.0;
    private double my = 1.0;
    private int vx = 0;
    private int vy = 0;
    private int vw = 0;
    private int vh = 0;
    private int vox = 0;
    private int voy = 0;
    private double vsx = 1.0;
    private double vsy = 1.0;
    private int cx = 0;
    private int cy = 0;
    private int cox = 0;
    private int coy = 0;
    private int mapMode = 1;
    private int bkColor = 0xFFFFFF;
    private int bkMode = 2;
    private int textColor = 0;
    private int textSpace = 0;
    private int textAlign = 0;
    private int textDx = 0;
    private int polyFillMode = 1;
    private int relAbsMode = 0;
    private int rop2Mode = 13;
    private int stretchBltMode = 2;
    private long layout = 0L;
    private long mapperFlags = 0L;
    private SvgBrush brush = null;
    private SvgFont font = null;
    private SvgPen pen = null;
    private Element mask = null;

    public SvgDc(SvgGdi svgGdi) {
        this.gdi = svgGdi;
    }

    public int getDpi() {
        return this.dpi;
    }

    public void setWindowOrgEx(int n, int n2, Point point) {
        if (point != null) {
            point.x = this.wx;
            point.y = this.wy;
        }
        this.wx = n;
        this.wy = n2;
    }

    public void setWindowExtEx(int n, int n2, Size size) {
        if (size != null) {
            size.width = this.ww;
            size.height = this.wh;
        }
        this.ww = n;
        this.wh = n2;
    }

    public void offsetWindowOrgEx(int n, int n2, Point point) {
        if (point != null) {
            point.x = this.wox;
            point.y = this.woy;
        }
        this.wox += n;
        this.woy += n2;
    }

    public void scaleWindowExtEx(int n, int n2, int n3, int n4, Size size) {
        this.wsx = this.wsx * (double)n / (double)n2;
        this.wsy = this.wsy * (double)n3 / (double)n4;
    }

    public int getWindowX() {
        return this.wx;
    }

    public int getWindowY() {
        return this.wy;
    }

    public int getWindowWidth() {
        return this.ww;
    }

    public int getWindowHeight() {
        return this.wh;
    }

    public void setViewportOrgEx(int n, int n2, Point point) {
        if (point != null) {
            point.x = this.vx;
            point.y = this.vy;
        }
        this.vx = n;
        this.vy = n2;
    }

    public void setViewportExtEx(int n, int n2, Size size) {
        if (size != null) {
            size.width = this.vw;
            size.height = this.vh;
        }
        this.vw = n;
        this.vh = n2;
    }

    public void offsetViewportOrgEx(int n, int n2, Point point) {
        if (point != null) {
            point.x = this.vox;
            point.y = this.voy;
        }
        this.vox = n;
        this.voy = n2;
    }

    public void scaleViewportExtEx(int n, int n2, int n3, int n4, Size size) {
        this.vsx = this.vsx * (double)n / (double)n2;
        this.vsy = this.vsy * (double)n3 / (double)n4;
    }

    public void offsetClipRgn(int n, int n2) {
        this.cox = n;
        this.coy = n2;
    }

    public int getMapMode() {
        return this.mapMode;
    }

    public void setMapMode(int n) {
        this.mapMode = n;
        switch (n) {
            case 5: {
                this.mx = 0.09;
                this.my = -0.09;
                break;
            }
            case 4: {
                this.mx = 0.9;
                this.my = -0.9;
                break;
            }
            case 3: {
                this.mx = 0.03543307;
                this.my = -0.03543307;
                break;
            }
            case 2: {
                this.mx = 0.3543307;
                this.my = -0.3543307;
                break;
            }
            case 6: {
                this.mx = 0.0625;
                this.my = -0.0625;
                break;
            }
            default: {
                this.mx = 1.0;
                this.my = 1.0;
            }
        }
    }

    public int getCurrentX() {
        return this.cx;
    }

    public int getCurrentY() {
        return this.cy;
    }

    public int getOffsetClipX() {
        return this.cox;
    }

    public int getOffsetClipY() {
        return this.coy;
    }

    public void moveToEx(int n, int n2, Point point) {
        if (point != null) {
            point.x = this.cx;
            point.y = this.cy;
        }
        this.cx = n;
        this.cy = n2;
    }

    public int toAbsoluteX(double d) {
        return (int)((double)(this.ww >= 0 ? 1 : -1) * (this.mx * d - (double)(this.wx + this.wox)) / this.wsx);
    }

    public int toAbsoluteY(double d) {
        return (int)((double)(this.wh >= 0 ? 1 : -1) * (this.my * d - (double)(this.wy + this.woy)) / this.wsy);
    }

    public int toRelativeX(double d) {
        return (int)((double)(this.ww >= 0 ? 1 : -1) * (this.mx * d) / this.wsx);
    }

    public int toRelativeY(double d) {
        return (int)((double)(this.wh >= 0 ? 1 : -1) * (this.my * d) / this.wsy);
    }

    public void setDpi(int n) {
        this.dpi = n > 0 ? n : 1440;
    }

    public int getBkColor() {
        return this.bkColor;
    }

    public void setBkColor(int n) {
        this.bkColor = n;
    }

    public int getBkMode() {
        return this.bkMode;
    }

    public void setBkMode(int n) {
        this.bkMode = n;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int n) {
        this.textColor = n;
    }

    public int getPolyFillMode() {
        return this.polyFillMode;
    }

    public void setPolyFillMode(int n) {
        this.polyFillMode = n;
    }

    public int getRelAbs() {
        return this.relAbsMode;
    }

    public void setRelAbs(int n) {
        this.relAbsMode = n;
    }

    public int getROP2() {
        return this.rop2Mode;
    }

    public void setROP2(int n) {
        this.rop2Mode = n;
    }

    public int getStretchBltMode() {
        return this.stretchBltMode;
    }

    public void setStretchBltMode(int n) {
        this.stretchBltMode = n;
    }

    public int getTextSpace() {
        return this.textSpace;
    }

    public void setTextSpace(int n) {
        this.textSpace = n;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(int n) {
        this.textAlign = n;
    }

    public int getTextCharacterExtra() {
        return this.textDx;
    }

    public void setTextCharacterExtra(int n) {
        this.textDx = n;
    }

    public long getLayout() {
        return this.layout;
    }

    public void setLayout(long l) {
        this.layout = l;
    }

    public long getMapperFlags() {
        return this.mapperFlags;
    }

    public void setMapperFlags(long l) {
        this.mapperFlags = l;
    }

    public SvgBrush getBrush() {
        return this.brush;
    }

    public void setBrush(SvgBrush svgBrush) {
        this.brush = svgBrush;
    }

    public SvgFont getFont() {
        return this.font;
    }

    public void setFont(SvgFont svgFont) {
        this.font = svgFont;
    }

    public SvgPen getPen() {
        return this.pen;
    }

    public void setPen(SvgPen svgPen) {
        this.pen = svgPen;
    }

    public void setMask(Element element) {
        this.mask = element;
    }

    public Element getMask() {
        return this.mask;
    }

    public String getRopFilter(long l) {
        String string = null;
        Document document = this.gdi.getDocument();
        if (l == 66L) {
            string = "BLACKNESS_FILTER";
            Element element = document.getElementById(string);
            if (element == null) {
                element = this.gdi.getDocument().createElement("filter");
                element.setAttribute("id", string);
                element.setIdAttribute("id", true);
                Element element2 = document.createElement("feColorMatrix");
                element2.setAttribute("type", "matrix");
                element2.setAttribute("in", "SourceGraphic");
                element2.setAttribute("values", "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0");
                element.appendChild(element2);
                this.gdi.getDefsElement().appendChild(element);
            }
        } else if (l == 1114278L) {
            string = "NOTSRCERASE_FILTER";
            Element element = document.getElementById(string);
            if (element == null) {
                element = this.gdi.getDocument().createElement("filter");
                element.setAttribute("id", string);
                element.setIdAttribute("id", true);
                Element element3 = document.createElement("feComposite");
                element3.setAttribute("in", "SourceGraphic");
                element3.setAttribute("in2", "BackgroundImage");
                element3.setAttribute("operator", "arithmetic");
                element3.setAttribute("k1", "1");
                element3.setAttribute("result", "result0");
                element.appendChild(element3);
                Element element4 = document.createElement("feColorMatrix");
                element4.setAttribute("in", "result0");
                element4.setAttribute("values", "-1 0 0 0 1 0 -1 0 0 1 0 0 -1 0 1 0 0 0 1 0");
                element.appendChild(element4);
                this.gdi.getDefsElement().appendChild(element);
            }
        } else if (l == 0x330008L) {
            string = "NOTSRCCOPY_FILTER";
            Element element = document.getElementById(string);
            if (element == null) {
                element = this.gdi.getDocument().createElement("filter");
                element.setAttribute("id", string);
                element.setIdAttribute("id", true);
                Element element5 = document.createElement("feColorMatrix");
                element5.setAttribute("type", "matrix");
                element5.setAttribute("in", "SourceGraphic");
                element5.setAttribute("values", "-1 0 0 0 1 0 -1 0 0 1 0 0 -1 0 1 0 0 0 1 0");
                element.appendChild(element5);
                this.gdi.getDefsElement().appendChild(element);
            }
        } else if (l == 4457256L) {
            string = "SRCERASE_FILTER";
            Element element = document.getElementById(string);
            if (element == null) {
                element = this.gdi.getDocument().createElement("filter");
                element.setAttribute("id", string);
                element.setIdAttribute("id", true);
                Element element6 = document.createElement("feColorMatrix");
                element6.setAttribute("type", "matrix");
                element6.setAttribute("in", "BackgroundImage");
                element6.setAttribute("values", "-1 0 0 0 1 0 -1 0 0 1 0 0 -1 0 1 0 0 0 1 0");
                element6.setAttribute("result", "result0");
                element.appendChild(element6);
                Element element7 = document.createElement("feComposite");
                element7.setAttribute("in", "SourceGraphic");
                element7.setAttribute("in2", "result0");
                element7.setAttribute("operator", "arithmetic");
                element7.setAttribute("k2", "1");
                element7.setAttribute("k3", "1");
                element.appendChild(element7);
                this.gdi.getDefsElement().appendChild(element);
            }
        } else if (l != 5898313L && l != 0x660046L) {
            if (l == 0x550009L) {
                string = "DSTINVERT_FILTER";
                Element element = document.getElementById(string);
                if (element == null) {
                    element = this.gdi.getDocument().createElement("filter");
                    element.setAttribute("id", string);
                    element.setIdAttribute("id", true);
                    Element element8 = document.createElement("feColorMatrix");
                    element8.setAttribute("type", "matrix");
                    element8.setAttribute("in", "BackgroundImage");
                    element8.setAttribute("values", "-1 0 0 0 1 0 -1 0 0 1 0 0 -1 0 1 0 0 0 1 0");
                    element.appendChild(element8);
                    this.gdi.getDefsElement().appendChild(element);
                }
            } else if (l == 8913094L) {
                string = "SRCAND_FILTER";
                Element element = document.getElementById(string);
                if (element == null) {
                    element = this.gdi.getDocument().createElement("filter");
                    element.setAttribute("id", string);
                    element.setIdAttribute("id", true);
                    Element element9 = document.createElement("feComposite");
                    element9.setAttribute("in", "SourceGraphic");
                    element9.setAttribute("in2", "BackgroundImage");
                    element9.setAttribute("operator", "arithmetic");
                    element9.setAttribute("k1", "1");
                    element.appendChild(element9);
                    this.gdi.getDefsElement().appendChild(element);
                }
            } else if (l == 12255782L) {
                string = "MERGEPAINT_FILTER";
                Element element = document.getElementById(string);
                if (element == null) {
                    element = this.gdi.getDocument().createElement("filter");
                    element.setAttribute("id", string);
                    element.setIdAttribute("id", true);
                    Element element10 = document.createElement("feColorMatrix");
                    element10.setAttribute("type", "matrix");
                    element10.setAttribute("in", "SourceGraphic");
                    element10.setAttribute("values", "-1 0 0 0 1 0 -1 0 0 1 0 0 -1 0 1 0 0 0 1 0");
                    element10.setAttribute("result", "result0");
                    element.appendChild(element10);
                    Element element11 = document.createElement("feComposite");
                    element11.setAttribute("in", "result0");
                    element11.setAttribute("in2", "BackgroundImage");
                    element11.setAttribute("operator", "arithmetic");
                    element11.setAttribute("k1", "1");
                    element.appendChild(element11);
                    this.gdi.getDefsElement().appendChild(element);
                }
            } else if (l != 0xC000CAL) {
                Element element;
                if (l == 15597702L) {
                    string = "SRCPAINT_FILTER";
                    Element element12 = document.getElementById(string);
                    if (element12 == null) {
                        element12 = this.gdi.getDocument().createElement("filter");
                        element12.setAttribute("id", string);
                        element12.setIdAttribute("id", true);
                        Element element13 = document.createElement("feComposite");
                        element13.setAttribute("in", "SourceGraphic");
                        element13.setAttribute("in2", "BackgroundImage");
                        element13.setAttribute("operator", "arithmetic");
                        element13.setAttribute("k2", "1");
                        element13.setAttribute("k3", "1");
                        element12.appendChild(element13);
                        this.gdi.getDefsElement().appendChild(element12);
                    }
                } else if (l != 15728673L && l != 16452105L && l == 16711778L && (element = document.getElementById(string = "WHITENESS_FILTER")) == null) {
                    element = this.gdi.getDocument().createElement("filter");
                    element.setAttribute("id", string);
                    element.setIdAttribute("id", true);
                    Element element14 = document.createElement("feColorMatrix");
                    element14.setAttribute("type", "matrix");
                    element14.setAttribute("in", "SourceGraphic");
                    element14.setAttribute("values", "1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0");
                    element.appendChild(element14);
                    this.gdi.getDefsElement().appendChild(element);
                }
            }
        }
        if (string != null) {
            if (!document.getDocumentElement().hasAttribute("enable-background")) {
                document.getDocumentElement().setAttribute("enable-background", "new");
            }
            return "url(#" + string + ")";
        }
        return null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public String toString() {
        return "SvgDc [gdi=" + this.gdi + ", dpi=" + this.dpi + ", wx=" + this.wx + ", wy=" + this.wy + ", ww=" + this.ww + ", wh=" + this.wh + ", wox=" + this.wox + ", woy=" + this.woy + ", wsx=" + this.wsx + ", wsy=" + this.wsy + ", mx=" + this.mx + ", my=" + this.my + ", vx=" + this.vx + ", vy=" + this.vy + ", vw=" + this.vw + ", vh=" + this.vh + ", vox=" + this.vox + ", voy=" + this.voy + ", vsx=" + this.vsx + ", vsy=" + this.vsy + ", cx=" + this.cx + ", cy=" + this.cy + ", mapMode=" + this.mapMode + ", bkColor=" + this.bkColor + ", bkMode=" + this.bkMode + ", textColor=" + this.textColor + ", textSpace=" + this.textSpace + ", textAlign=" + this.textAlign + ", textDx=" + this.textDx + ", polyFillMode=" + this.polyFillMode + ", relAbsMode=" + this.relAbsMode + ", rop2Mode=" + this.rop2Mode + ", stretchBltMode=" + this.stretchBltMode + ", brush=" + this.brush + ", font=" + this.font + ", pen=" + this.pen + "]";
    }
}

