/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.base.action;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import net.mingsoft.base.util.BundleUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAction {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static String[] mobileGateWayHeaders = new String[]{"ZXWAP", "chinamobile.com", "monternet.com", "infoX", "XMS 724Solutions HTG", "wap.lizongbo.com", "Bytemobile"};
    private static String[] pcHeaders = new String[]{"Windows 98", "Windows ME", "Windows 2000", "Windows XP", "Windows NT", "Ubuntu"};
    private static String[] mobileUserAgents = new String[]{"Nokia", "SAMSUNG", "MIDP-2", "CLDC1.1", "SymbianOS", "MAUI", "UNTRUSTED/1.0", "Windows CE", "iPhone", "iPad", "Android", "BlackBerry", "UCWEB", "ucweb", "BREW", "J2ME", "YULONG", "YuLong", "COOLPAD", "TIANYU", "TY-", "K-Touch", "Haier", "DOPOD", "Lenovo", "LENOVO", "HUAQIN", "AIGO-", "CTC/1.0", "CTC/2.0", "CMCC", "DAXIAN", "MOT-", "SonyEricsson", "GIONEE", "HTC", "ZTE", "HUAWEI", "webOS", "GoBrowser", "IEMobile", "WAP2.0"};

    @Deprecated
    protected String getLocaleString(String key, String resources) {
        return BundleUtil.getLocaleString(key, resources);
    }

    @Deprecated
    protected String getUrl(HttpServletRequest request) {
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName();
        basePath = request.getServerPort() == 80 ? basePath + path : basePath + ":" + request.getServerPort() + path;
        return basePath;
    }

    @Deprecated
    protected String getDomain(HttpServletRequest request) {
        String path = request.getContextPath();
        String domain = request.getServerName();
        domain = request.getServerPort() == 80 ? domain + path : domain + ":" + request.getServerPort() + path;
        return domain;
    }

    protected String getHost(HttpServletRequest request) {
        String basePath = request.getServerName();
        if (request.getServerPort() != 80) {
            basePath = basePath + ":" + request.getServerPort();
        }
        return basePath;
    }

    protected String getHostIp() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Deprecated
    protected String getResString(String key) {
        return BundleUtil.getResString(key);
    }

    @Deprecated
    protected String getResString(String key, ResourceBundle rb) {
        return BundleUtil.getResString(key, rb);
    }

    protected String getResString(String key, String ... fullStrs) {
        return BundleUtil.getResString(key, fullStrs);
    }

    @Deprecated
    protected String getResString(String key, ResourceBundle rb, String ... fullStrs) {
        return BundleUtil.getResString(key, rb, fullStrs);
    }

    public boolean isMobileDevice(HttpServletRequest request) {
        int i;
        boolean b = false;
        boolean pcFlag = false;
        boolean mobileFlag = false;
        String via = request.getHeader("Via");
        String userAgent = request.getHeader("user-agent");
        for (i = 0; via != null && !via.trim().equals("") && i < mobileGateWayHeaders.length; ++i) {
            if (!via.contains(mobileGateWayHeaders[i])) continue;
            mobileFlag = true;
            break;
        }
        for (i = 0; !mobileFlag && userAgent != null && !userAgent.trim().equals("") && i < mobileUserAgents.length; ++i) {
            if (!userAgent.contains(mobileUserAgents[i])) continue;
            mobileFlag = true;
            break;
        }
        for (i = 0; userAgent != null && !userAgent.trim().equals("") && i < pcHeaders.length; ++i) {
            if (!userAgent.contains(pcHeaders[i])) continue;
            pcFlag = true;
            break;
        }
        if (mobileFlag && !pcFlag) {
            b = true;
        }
        return b;
    }

    protected Map<String, String> getMapByProperties(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return null;
        }
        ResourceBundle rb = ResourceBundle.getBundle(filePath);
        return this.getMapByProperties(rb);
    }

    protected Map<String, String> getMapByProperties(ResourceBundle rb) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<String> en = rb.getKeys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            map.put(key, rb.getString(key));
        }
        return map;
    }
}

