/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.sql.Clob;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.base.util.SqlInjectionUtil;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.bean.ModelJsonBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.constant.e.ModelCustomTypeEnum;
import net.mingsoft.mdiy.entity.ModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u540e\u7aef-\u81ea\u5b9a\u4e49\u6a21\u5757\u63a5\u53e3"})
@Controller(value="coMdiyModelAction")
@RequestMapping(value={"/${ms.manager.path}/mdiy/model"})
public class ModelAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;
    private Pattern filePattern = Pattern.compile("(src|href)=\"(upload/.*?(png|jpg|gif))");

    @ApiIgnore
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/mdiy/model/index";
    }

    @ApiIgnore
    @GetMapping(value={"/form"})
    public String form(@ModelAttribute ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, ModelMap modelMap) {
        if (modelEntity.getId() != null) {
            BaseEntity _modelEntity = (BaseEntity)this.modelBiz.getById((Serializable)((Object)modelEntity.getId()));
            modelMap.addAttribute("modelEntity", (Object)_modelEntity);
        }
        return "/mdiy/model/form";
    }

    @ApiOperation(value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelName", value="\u6a21\u578b\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="modelTableName", value="\u6a21\u578b\u8868\u540d", required=false, paramType="query"), @ApiImplicitParam(name="appId", value="\u5e94\u7528\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="modelJson", value="json", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u4fee\u6539\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u4fee\u6539\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="del", value="\u5220\u9664\u6807\u8bb0", required=false, paramType="query"), @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model, BindingResult result) {
        modelEntity.setModelCustomType(ModelCustomTypeEnum.MODEL.getLabel());
        BasicUtil.startPage();
        List modelList = this.modelBiz.query(modelEntity);
        return ResultData.build().success((Object)new EUListBean(modelList, (int)BasicUtil.endPage((List)modelList).getTotal()));
    }

    @ApiOperation(value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u6570\u636e\u63a5\u53e3")
    @GetMapping(value={"/data"})
    @ResponseBody
    public ResultData data(String modelId, String linkId, HttpServletResponse response, HttpServletRequest request, ModelMap modelMap) {
        List listMap;
        SqlInjectionUtil.filterContent((String[])new String[]{linkId});
        ModelEntity model = (ModelEntity)((Object)this.modelBiz.getById((Serializable)((Object)modelId)));
        HashMap data = null;
        if (StringUtils.isBlank((CharSequence)linkId)) {
            linkId = "0";
        }
        if (ObjectUtil.isNotNull((Object)((Object)model)) && (listMap = (List)this.modelBiz.excuteSql(StrUtil.format((CharSequence)"select * from {} where link_id = '{}'", (Object[])new Object[]{model.getModelTableName(), linkId}))).size() > 0) {
            data = new HashMap();
            for (Object o : ((Map)listMap.get(0)).keySet()) {
                Object _o = ((Map)listMap.get(0)).get(o);
                if (_o instanceof Clob) {
                    _o = StringUtil.clobStr((Clob)((Clob)_o));
                }
                data.put(this.getCamelCaseString(o.toString(), false), _o);
            }
        }
        return ResultData.build().success(data);
    }

    private String getCamelCaseString(String inputString, boolean firstCharacterUppercase) {
        StringBuilder sb = new StringBuilder();
        boolean nextUpperCase = false;
        block3: for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            switch (c) {
                case ' ': 
                case '#': 
                case '$': 
                case '&': 
                case '-': 
                case '/': 
                case '@': 
                case '_': {
                    if (sb.length() <= 0) continue block3;
                    nextUpperCase = true;
                    continue block3;
                }
                default: {
                    if (nextUpperCase) {
                        sb.append(Character.toUpperCase(c));
                        nextUpperCase = false;
                        continue block3;
                    }
                    sb.append(Character.toLowerCase(c));
                }
            }
        }
        if (firstCharacterUppercase) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    @ApiOperation(value="\u4fdd\u5b58\u6a21\u578b\u63a5\u53e3")
    @LogAnn(title="\u4fdd\u5b58\u6a21\u578b", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/data/save"})
    @ResponseBody
    public ResultData save(String linkId, String modelId, HttpServletResponse response, HttpServletRequest request, ModelMap modelMap) {
        SqlInjectionUtil.filterContent((String[])new String[]{linkId});
        ModelEntity model = (ModelEntity)((Object)this.modelBiz.getById((Serializable)((Object)modelId)));
        if (ObjectUtil.isNotNull((Object)((Object)model)) && StringUtils.isNotBlank((CharSequence)linkId)) {
            List listMap = (List)this.modelBiz.excuteSql(StrUtil.format((CharSequence)"select * from {} where link_id = '{}'", (Object[])new Object[]{model.getModelTableName(), linkId}));
            if (CollUtil.isNotEmpty((Collection)listMap)) {
                return ResultData.build().error(linkId);
            }
            Map requestMap = BasicUtil.assemblyRequestMap();
            Map fieldMap = model.getFieldMap();
            HashMap fields = new HashMap();
            for (String s : requestMap.keySet()) {
                if (!fieldMap.containsKey(s)) continue;
                fields.put(fieldMap.get(s).toString(), requestMap.get(s));
            }
            fields.put("CREATE_DATE", new Date());
            fields.put("UPDATE_DATE", new Date());
            fields.put("CREATE_BY", BasicUtil.getManager().getId());
            fields.put("LINK_ID", linkId);
            this.modelBiz.insertBySQL(model.getModelTableName(), fields);
            return ResultData.build().success((Object)linkId);
        }
        return ResultData.build().error(linkId);
    }

    @ApiOperation(value="\u66f4\u65b0\u6a21\u578b\u63a5\u53e3")
    @LogAnn(title="\u66f4\u65b0\u6a21\u578b", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/data/update"})
    @ResponseBody
    public ResultData update(String linkId, String modelId, HttpServletResponse response, HttpServletRequest request, ModelMap modelMap) {
        SqlInjectionUtil.filterContent((String[])new String[]{linkId});
        ModelEntity model = (ModelEntity)((Object)this.modelBiz.getById((Serializable)((Object)modelId)));
        if (ObjectUtil.isNotNull((Object)((Object)model)) && StringUtils.isNotBlank((CharSequence)linkId)) {
            Map requestMap = BasicUtil.assemblyRequestMap();
            Map fieldMap = model.getFieldMap();
            HashMap fields = new HashMap();
            for (String s : requestMap.keySet()) {
                if (!fieldMap.containsKey(s)) continue;
                fields.put(fieldMap.get(s).toString(), requestMap.get(s));
            }
            HashMap<String, String> where = new HashMap<String, String>();
            where.put("LINK_ID", linkId);
            List listMap = (List)this.modelBiz.excuteSql(StrUtil.format((CharSequence)"select * from {} where link_id = '{}'", (Object[])new Object[]{model.getModelTableName(), linkId}));
            if (CollUtil.isEmpty((Collection)listMap)) {
                fields.put("LINK_ID", linkId);
                fields.put("CREATE_DATE", new Date());
                fields.put("UPDATE_DATE", new Date());
                fields.put("CREATE_BY", BasicUtil.getManager().getId());
                this.modelBiz.insertBySQL(model.getModelTableName(), fields);
            } else {
                fields.put("UPDATE_DATE", new Date());
                fields.put("UPDATE_BY", BasicUtil.getManager().getId());
                this.modelBiz.updateBySQL(model.getModelTableName(), fields, where);
            }
            return ResultData.build().success((Object)linkId);
        }
        return ResultData.build().error(linkId);
    }

    @ApiOperation(value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelName", value="\u6a21\u578b\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="modelTableName", value="\u6a21\u578b\u8868\u540d", required=false, paramType="query"), @ApiImplicitParam(name="appId", value="\u5e94\u7528\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="modelJson", value="json", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u4fee\u6539\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u4fee\u6539\u65f6\u95f4", required=false, paramType="query")})
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request) {
        if (modelEntity == null && StringUtils.isEmpty((CharSequence)modelEntity.getModelName())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.name")}));
        }
        modelEntity.setModelCustomType(ModelCustomTypeEnum.MODEL.getLabel());
        ModelEntity model = (ModelEntity)((Object)this.modelBiz.getOne((Wrapper)new QueryWrapper((Object)modelEntity)));
        return ResultData.build().success((Object)model);
    }

    @ApiOperation(value="\u5bfc\u5165\u81ea\u5b9a\u4e49\u6a21\u578b\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelJson", value="json", required=true, paramType="query")})
    @LogAnn(title="\u5bfc\u5165\u81ea\u5b9a\u4e49\u6a21\u578b", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/importJson"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:model:importJson"})
    public ResultData importJson(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (StringUtils.isBlank((CharSequence)modelEntity.getModelJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.json")}));
        }
        modelEntity.setModelCustomType(ModelCustomTypeEnum.MODEL.getLabel());
        ModelJsonBean modelJsonBean = new ModelJsonBean();
        try {
            modelJsonBean = (ModelJsonBean)JSONObject.parseObject((String)modelEntity.getModelJson(), ModelJsonBean.class);
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.json")}));
        }
        if (this.modelBiz.importModel(ModelCustomTypeEnum.MODEL.getLabel(), modelJsonBean, modelEntity.getModelType())) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("table.name")}));
    }

    @ApiOperation(value="\u66f4\u65b0\u5bfc\u5165\u81ea\u5b9a\u4e49\u6a21\u578b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelJson", value="json", required=true, paramType="query")})
    @LogAnn(title="\u66f4\u65b0\u81ea\u5b9a\u4e49\u6a21\u578b", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/updateJson"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:model:update"})
    public ResultData updateJson(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (StringUtils.isBlank((CharSequence)modelEntity.getModelJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.json")}));
        }
        if (StringUtils.isBlank((CharSequence)modelEntity.getId())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("id")}));
        }
        ModelJsonBean modelJsonBean = null;
        try {
            modelJsonBean = (ModelJsonBean)JSONObject.parseObject((String)modelEntity.getModelJson(), ModelJsonBean.class);
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.json")}));
        }
        if (this.modelBiz.updateConfig(modelEntity.getId(), modelJsonBean, modelEntity.getModelType())) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("table.name")}));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u6a21\u578b", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:model:del"})
    public ResultData delete(@RequestBody List<ModelEntity> models, HttpServletResponse response, HttpServletRequest request) {
        String[] ids = new String[models.size()];
        for (int i = 0; i < models.size(); ++i) {
            ids[i] = models.get(i).getId();
            this.modelBiz.dropTable(models.get(i).getModelTableName());
        }
        this.modelBiz.delete(ids);
        return ResultData.build().success();
    }
}

