/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.mdiy.bean.ModelJsonBean;
import net.mingsoft.mdiy.biz.IConfigBiz;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.constant.e.ModelCustomTypeEnum;
import net.mingsoft.mdiy.dao.IModelDao;
import net.mingsoft.mdiy.entity.ConfigEntity;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.mdiy.util.ConfigUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="mdiyModelBizImpl")
@Transactional(rollbackFor={Exception.class})
public class ModelBizImpl
extends BaseBizImpl<IModelDao, ModelEntity>
implements IModelBiz {
    @Autowired
    private IModelDao modelDao;
    @Autowired
    private IConfigBiz configBiz;

    protected IBaseDao getDao() {
        return this.modelDao;
    }

    @Override
    public boolean importConfig(String customType, ModelJsonBean modelJsonBean) {
        if (StringUtils.isEmpty((CharSequence)customType) || modelJsonBean == null) {
            return false;
        }
        return this.importModel(customType, modelJsonBean, "");
    }

    @Override
    public boolean importModel(String customType, ModelJsonBean modelJsonBean, String modelType) {
        if (StringUtils.isEmpty((CharSequence)customType) || modelJsonBean == null) {
            return false;
        }
        ModelEntity model = new ModelEntity();
        model.setModelName(modelJsonBean.getTitle());
        model.setModelCustomType(customType);
        ModelEntity modelEntity = (ModelEntity)((Object)super.getOne((Wrapper)new QueryWrapper((Object)model)));
        if (ObjectUtil.isNotNull((Object)((Object)modelEntity))) {
            return false;
        }
        if (customType.equalsIgnoreCase(ModelCustomTypeEnum.MODEL.getLabel())) {
            String[] modelSqls;
            model.setModelTableName("MDIY_MODEL_" + modelJsonBean.getTableName());
            for (String sql : modelSqls = modelJsonBean.getSql().replace("{model}", "MDIY_MODEL_").trim().split(";")) {
                if (StringUtils.isBlank((CharSequence)sql) || StrUtil.containsAnyIgnoreCase((CharSequence)sql, (CharSequence[])new CharSequence[]{"INSERT INTO", "DELETE "})) continue;
                this.modelDao.excuteSql(sql);
            }
        }
        if (customType.equalsIgnoreCase(ModelCustomTypeEnum.FORM.getLabel())) {
            String[] formSqls;
            model.setModelTableName("MDIY_FORM_" + modelJsonBean.getTableName());
            modelJsonBean.setSql(modelJsonBean.getSql().replaceAll("\\W?LINK_ID\\W? \\w+\\(\\d+\\) DEFAULT NULL,", ""));
            for (String sql : formSqls = modelJsonBean.getSql().replace("{model}", "MDIY_FORM_").trim().split(";")) {
                if (StringUtils.isBlank((CharSequence)sql) || StrUtil.containsAnyIgnoreCase((CharSequence)sql, (CharSequence[])new CharSequence[]{"INSERT INTO", "DELETE ", "UNIQUE_LINK_ID`(`LINK_ID`)", "UNIQUE(\"LINK_ID\")"})) continue;
                sql = sql.replace("FROM dual", "FROM dual;").replace("END", "END;");
                this.modelDao.excuteSql(sql);
                this.LOG.debug(sql);
            }
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("html", modelJsonBean.getHtml());
        json.put("searchJson", modelJsonBean.getSearchJson());
        json.put("script", modelJsonBean.getScript());
        json.put("isWebSubmit", modelJsonBean.isWebSubmit());
        model.setModelField(modelJsonBean.getField());
        model.setModelType(modelType);
        model.setModelJson(JSONObject.toJSONString(json));
        super.save((Object)model);
        return true;
    }

    @Override
    public boolean updateConfig(String modelId, ModelJsonBean modelJsonBean) {
        if (StringUtils.isEmpty((CharSequence)modelId) || modelJsonBean == null) {
            return false;
        }
        return this.updateConfig(modelId, modelJsonBean, "");
    }

    @Override
    public boolean updateConfig(String modelId, ModelJsonBean modelJsonBean, String modelType) {
        if (StringUtils.isEmpty((CharSequence)modelId) || modelJsonBean == null) {
            return false;
        }
        ModelEntity modelEntity = (ModelEntity)((Object)super.getById((Serializable)((Object)modelId)));
        if (ObjectUtil.isNull((Object)((Object)modelEntity))) {
            return false;
        }
        ModelEntity model = new ModelEntity();
        model.setModelName(modelJsonBean.getTitle());
        model.setModelCustomType(modelEntity.getModelCustomType());
        ModelEntity oldModel = (ModelEntity)((Object)super.getOne((Wrapper)new QueryWrapper((Object)model)));
        if (ObjectUtil.isNotNull((Object)((Object)oldModel)) && !modelEntity.getId().equals(oldModel.getId())) {
            return false;
        }
        String oldTableName = modelEntity.getModelTableName();
        String rename = "ALTER  TABLE {} RENAME TO {};";
        if (modelEntity.getModelCustomType().equalsIgnoreCase(ModelCustomTypeEnum.MODEL.getLabel())) {
            modelEntity.setModelTableName(("MDIY_MODEL_" + modelJsonBean.getTableName()).toUpperCase());
            this.updateTable(modelEntity.getModelField(), modelJsonBean.getField(), modelEntity.getModelTableName());
            if (!oldTableName.equals(modelEntity.getModelTableName()) && StringUtils.isNotBlank((CharSequence)(rename = StrUtil.format((CharSequence)rename, (Object[])new Object[]{oldTableName, modelEntity.getModelTableName()}))) && !StrUtil.containsAnyIgnoreCase((CharSequence)rename, (CharSequence[])new CharSequence[]{"INSERT INTO", "DELETE "})) {
                this.modelDao.excuteSql(rename);
            }
        }
        if (modelEntity.getModelCustomType().equalsIgnoreCase(ModelCustomTypeEnum.FORM.getLabel())) {
            modelEntity.setModelTableName(("MDIY_FORM_" + modelJsonBean.getTableName()).toUpperCase());
            this.updateTable(modelEntity.getModelField(), modelJsonBean.getField(), modelEntity.getModelTableName());
            if (!oldTableName.equals(modelEntity.getModelTableName()) && StringUtils.isNotBlank((CharSequence)(rename = StrUtil.format((CharSequence)rename, (Object[])new Object[]{oldTableName, modelEntity.getModelTableName()}))) && !StrUtil.containsAnyIgnoreCase((CharSequence)rename, (CharSequence[])new CharSequence[]{"INSERT INTO", "DELETE "})) {
                this.modelDao.excuteSql(rename);
            }
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("html", modelJsonBean.getHtml());
        json.put("script", modelJsonBean.getScript());
        json.put("searchJson", modelJsonBean.getSearchJson());
        json.put("isWebSubmit", modelJsonBean.isWebSubmit());
        modelEntity.setModelField(modelJsonBean.getField());
        modelEntity.setModelName(modelJsonBean.getTitle());
        modelEntity.setModelType(modelType);
        modelEntity.setModelJson(JSONObject.toJSONString(json));
        super.updateById((Object)modelEntity);
        List mapList = (List)JSONObject.parse((String)modelJsonBean.getField());
        List fieldList = mapList.stream().map(map -> StrUtil.toCamelCase((CharSequence)map.get("field").toString().toLowerCase())).collect(Collectors.toList());
        fieldList.add("linkId");
        fieldList.add("modelId");
        ConfigEntity configEntity = (ConfigEntity)((Object)this.configBiz.getOne((Wrapper)new QueryWrapper().eq((Object)"config_name", (Object)modelEntity.getModelName())));
        Map map2 = ConfigUtil.getMap(modelEntity.getModelName());
        if (CollUtil.isNotEmpty((Map)map2)) {
            Object[] keys;
            for (Object key : keys = map2.keySet().toArray()) {
                if (fieldList.contains(key)) continue;
                map2.remove(key);
            }
            configEntity.setConfigData(JSONObject.toJSONString((Object)map2));
            this.configBiz.updateById((Object)configEntity);
        }
        return true;
    }

    @Override
    public boolean delete(List<String> ids) {
        for (String id : ids) {
            ModelEntity modelEntity = (ModelEntity)((Object)super.getById((Serializable)((Object)id)));
            boolean flag = super.removeById((Serializable)((Object)id));
            if (!flag) {
                this.LOG.debug("{}\u5220\u9664\u5931\u8d25", (Object)modelEntity.getModelTableName());
                break;
            }
            this.modelDao.dropTable(modelEntity.getModelTableName());
        }
        return true;
    }

    private void updateTable(String oldStr, String newStr, String tableName) {
        List oldList = JSONObject.parseArray((String)oldStr, Dict.class);
        List newList = JSONObject.parseArray((String)newStr, Dict.class);
        StringBuffer stringBuffer = new StringBuffer();
        Collection disMap = CollUtil.disjunction((Collection)oldList, (Collection)newList);
        if (CollUtil.isNotEmpty((Collection)disMap)) {
            String[] formSqls;
            Collection newIntersection;
            Collection oldIntersection = CollUtil.intersection((Collection)oldList, (Collection)disMap);
            String alertTable = "";
            stringBuffer.append(alertTable);
            if (CollUtil.isNotEmpty((Collection)oldIntersection)) {
                String dropSql = StrUtil.format((CharSequence)"ALTER TABLE {} ", (Object[])new Object[]{tableName.toUpperCase()}).concat("DROP COLUMN {};");
                List dropList = oldIntersection.stream().map(dict -> StrUtil.format((CharSequence)dropSql, (Object[])new Object[]{dict.getStr("field")})).collect(Collectors.toList());
                stringBuffer.append(CollUtil.join(dropList, (CharSequence)";"));
            }
            if (CollUtil.isNotEmpty((Collection)(newIntersection = CollUtil.intersection((Collection)newList, (Collection)disMap)))) {
                if (CollUtil.isNotEmpty((Collection)oldIntersection)) {
                    stringBuffer.append(";");
                }
                String addSql = StrUtil.format((CharSequence)"ALTER TABLE {} ", (Object[])new Object[]{tableName.toUpperCase()}).concat("ADD COLUMN {} {}({}) NULL;");
                List addList = newIntersection.stream().map(dict -> StrUtil.format((CharSequence)addSql, (Object[])new Object[]{dict.getStr("field"), dict.getStr("jdbcType"), dict.getStr("length")})).collect(Collectors.toList());
                stringBuffer.append(CollUtil.join(addList, (CharSequence)";"));
            }
            stringBuffer.append(";");
            this.LOG.debug("\u6267\u884c\u7684SQL{}", (Object)stringBuffer);
            for (String sql : formSqls = stringBuffer.toString().split(";")) {
                if (StringUtils.isBlank((CharSequence)sql) || StrUtil.containsAnyIgnoreCase((CharSequence)sql, (CharSequence[])new CharSequence[]{"INSERT INTO", "DELETE "})) continue;
                this.modelDao.excuteSql(sql);
            }
        }
    }
}

