/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.clienthints.parsers;

import java.util.Map;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzerDirect;
import nl.basjes.parse.useragent.clienthints.ClientHints;
import nl.basjes.parse.useragent.clienthints.parsers.CHParser;

public class ParseSecChUaMobile
implements CHParser {
    public static final String HEADER_FIELD = "Sec-CH-UA-Mobile";
    public static final String HEADER_SPEC_URL = "https://wicg.github.io/ua-client-hints/#sec-ch-ua-mobile";
    public static final String HEADER_SPEC = "The Sec-CH-UA-Mobile request header field gives a server information about whether or not a user agent prefers a \"mobile\" user experience.";
    public static final String FIELD_NAME = "secChUaMobile";

    @Override
    @Nonnull
    public ClientHints parse(@Nonnull Map<String, String> clientHintsHeaders, @Nonnull ClientHints clientHints, @Nonnull String headerName) {
        String input = clientHintsHeaders.get(headerName);
        Boolean parsedBoolean = this.parseBoolean(input);
        if (parsedBoolean != null) {
            clientHints.setMobile(parsedBoolean);
        }
        return clientHints;
    }

    @Override
    @Nonnull
    public String inputField() {
        return HEADER_FIELD;
    }

    public static AbstractUserAgentAnalyzerDirect.HeaderSpecification getHeaderSpecification() {
        return new AbstractUserAgentAnalyzerDirect.HeaderSpecification(HEADER_FIELD, HEADER_SPEC_URL, HEADER_SPEC, FIELD_NAME);
    }
}

