/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.engine.impl.GroupQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.exception.ActivitiConflictException;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.identity.GroupPaginateList;
import org.activiti.rest.service.api.identity.GroupRequest;
import org.activiti.rest.service.api.identity.GroupResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GroupCollectionResource {
    protected static HashMap<String, QueryProperty> properties = new HashMap();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected IdentityService identityService;

    @RequestMapping(value={"/identity/groups"}, method={RequestMethod.GET}, produces={"application/json"})
    public DataResponse getGroups(@RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        GroupQuery query = this.identityService.createGroupQuery();
        if (allRequestParams.containsKey("id")) {
            query.groupId(allRequestParams.get("id"));
        }
        if (allRequestParams.containsKey("name")) {
            query.groupName(allRequestParams.get("name"));
        }
        if (allRequestParams.containsKey("nameLike")) {
            query.groupNameLike(allRequestParams.get("nameLike"));
        }
        if (allRequestParams.containsKey("type")) {
            query.groupType(allRequestParams.get("type"));
        }
        if (allRequestParams.containsKey("member")) {
            query.groupMember(allRequestParams.get("member"));
        }
        if (allRequestParams.containsKey("potentialStarter")) {
            query.potentialStarter(allRequestParams.get("potentialStarter"));
        }
        return new GroupPaginateList(this.restResponseFactory).paginateList(allRequestParams, (Query)query, "id", properties);
    }

    @RequestMapping(value={"/identity/groups"}, method={RequestMethod.POST}, produces={"application/json"})
    public GroupResponse createGroup(@RequestBody GroupRequest groupRequest, HttpServletRequest httpRequest, HttpServletResponse response) {
        if (groupRequest.getId() == null) {
            throw new ActivitiIllegalArgumentException("Id cannot be null.");
        }
        if (this.identityService.createGroupQuery().groupId(groupRequest.getId()).count() > 0L) {
            throw new ActivitiConflictException("A group with id '" + groupRequest.getId() + "' already exists.");
        }
        Group created = this.identityService.newGroup(groupRequest.getId());
        created.setId(groupRequest.getId());
        created.setName(groupRequest.getName());
        created.setType(groupRequest.getType());
        this.identityService.saveGroup(created);
        response.setStatus(HttpStatus.CREATED.value());
        return this.restResponseFactory.createGroupResponse(created);
    }

    static {
        properties.put("id", (QueryProperty)GroupQueryProperty.GROUP_ID);
        properties.put("name", (QueryProperty)GroupQueryProperty.NAME);
        properties.put("type", (QueryProperty)GroupQueryProperty.TYPE);
    }
}

