/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl;

import java.io.Serializable;
import java.util.List;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.ManagementService;
import org.activiti5.engine.impl.Direction;
import org.activiti5.engine.impl.ManagementServiceImpl;
import org.activiti5.engine.impl.Page;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.db.ListQueryParameterObject;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.interceptor.CommandExecutor;
import org.activiti5.engine.query.Query;
import org.activiti5.engine.query.QueryProperty;

public abstract class AbstractQuery<T extends Query<?, ?>, U>
extends ListQueryParameterObject
implements Command<Object>,
Query<T, U>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SORTORDER_ASC = "asc";
    public static final String SORTORDER_DESC = "desc";
    protected transient CommandExecutor commandExecutor;
    protected transient CommandContext commandContext;
    protected String databaseType;
    protected String orderBy;
    protected ResultType resultType;
    protected QueryProperty orderProperty;
    protected NullHandlingOnOrder nullHandlingOnOrder;

    protected AbstractQuery() {
        this.parameter = this;
    }

    protected AbstractQuery(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public AbstractQuery(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public AbstractQuery(ManagementService managementService) {
        this(((ManagementServiceImpl)managementService).getCommandExecutor());
    }

    public AbstractQuery<T, U> setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    public T orderBy(QueryProperty property) {
        this.orderProperty = property;
        return (T)this;
    }

    public T orderBy(QueryProperty property, NullHandlingOnOrder nullHandlingOnOrder) {
        this.orderBy(property);
        this.nullHandlingOnOrder = nullHandlingOnOrder;
        return (T)this;
    }

    @Override
    public T asc() {
        return this.direction(Direction.ASCENDING);
    }

    @Override
    public T desc() {
        return this.direction(Direction.DESCENDING);
    }

    public T direction(Direction direction) {
        if (this.orderProperty == null) {
            throw new ActivitiIllegalArgumentException("You should call any of the orderBy methods first before specifying a direction");
        }
        this.addOrder(this.orderProperty.getName(), direction.getName(), this.nullHandlingOnOrder);
        this.orderProperty = null;
        this.nullHandlingOnOrder = null;
        return (T)this;
    }

    protected void checkQueryOk() {
        if (this.orderProperty != null) {
            throw new ActivitiIllegalArgumentException("Invalid query: call asc() or desc() after using orderByXX()");
        }
    }

    @Override
    public U singleResult() {
        this.resultType = ResultType.SINGLE_RESULT;
        if (this.commandExecutor != null) {
            return (U)this.commandExecutor.execute(this);
        }
        return this.executeSingleResult(Context.getCommandContext());
    }

    @Override
    public List<U> list() {
        this.resultType = ResultType.LIST;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute(this);
        }
        return this.executeList(Context.getCommandContext(), null);
    }

    @Override
    public List<U> listPage(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.resultType = ResultType.LIST_PAGE;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute(this);
        }
        return this.executeList(Context.getCommandContext(), new Page(firstResult, maxResults));
    }

    @Override
    public long count() {
        this.resultType = ResultType.COUNT;
        if (this.commandExecutor != null) {
            return (Long)this.commandExecutor.execute(this);
        }
        return this.executeCount(Context.getCommandContext());
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.resultType == ResultType.LIST) {
            return this.executeList(commandContext, null);
        }
        if (this.resultType == ResultType.SINGLE_RESULT) {
            return this.executeSingleResult(commandContext);
        }
        if (this.resultType == ResultType.LIST_PAGE) {
            return this.executeList(commandContext, null);
        }
        return this.executeCount(commandContext);
    }

    public abstract long executeCount(CommandContext var1);

    public abstract List<U> executeList(CommandContext var1, Page var2);

    public U executeSingleResult(CommandContext commandContext) {
        List<U> results = this.executeList(commandContext, null);
        if (results.size() == 1) {
            return results.get(0);
        }
        if (results.size() > 1) {
            throw new ActivitiException("Query return " + results.size() + " results instead of max 1");
        }
        return null;
    }

    protected void addOrder(String column, String sortOrder, NullHandlingOnOrder nullHandlingOnOrder) {
        this.orderBy = this.orderBy == null ? "" : this.orderBy + ", ";
        String defaultOrderByClause = column + " " + sortOrder;
        if (nullHandlingOnOrder != null) {
            if (nullHandlingOnOrder.equals((Object)NullHandlingOnOrder.NULLS_FIRST)) {
                this.orderBy = "h2".equals(this.databaseType) || "hsql".equals(this.databaseType) || "postgres".equals(this.databaseType) || "oracle".equals(this.databaseType) ? this.orderBy + defaultOrderByClause + " NULLS FIRST" : ("mysql".equals(this.databaseType) ? this.orderBy + "isnull(" + column + ") desc," + defaultOrderByClause : ("db2".equals(this.databaseType) || "mssql".equals(this.databaseType) ? this.orderBy + "case when " + column + " is null then 0 else 1 end," + defaultOrderByClause : this.orderBy + defaultOrderByClause));
            } else if (nullHandlingOnOrder.equals((Object)NullHandlingOnOrder.NULLS_LAST)) {
                this.orderBy = "h2".equals(this.databaseType) || "hsql".equals(this.databaseType) || "postgres".equals(this.databaseType) || "oracle".equals(this.databaseType) ? this.orderBy + column + " " + sortOrder + " NULLS LAST" : ("mysql".equals(this.databaseType) ? this.orderBy + "isnull(" + column + ") asc," + defaultOrderByClause : ("db2".equals(this.databaseType) || "mssql".equals(this.databaseType) ? this.orderBy + "case when " + column + " is null then 1 else 0 end," + defaultOrderByClause : this.orderBy + defaultOrderByClause));
            }
        } else {
            this.orderBy = this.orderBy + defaultOrderByClause;
        }
    }

    @Override
    public String getOrderBy() {
        if (this.orderBy == null) {
            return super.getOrderBy();
        }
        return this.orderBy;
    }

    @Override
    public String getOrderByColumns() {
        return this.getOrderBy();
    }

    @Override
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public static enum NullHandlingOnOrder {
        NULLS_FIRST,
        NULLS_LAST;

    }

    private static enum ResultType {
        LIST,
        LIST_PAGE,
        SINGLE_RESULT,
        COUNT;

    }
}

