/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl;

import java.util.List;
import org.activiti5.engine.IdentityService;
import org.activiti5.engine.identity.Group;
import org.activiti5.engine.identity.GroupQuery;
import org.activiti5.engine.identity.NativeGroupQuery;
import org.activiti5.engine.identity.NativeUserQuery;
import org.activiti5.engine.identity.Picture;
import org.activiti5.engine.identity.User;
import org.activiti5.engine.identity.UserQuery;
import org.activiti5.engine.impl.NativeGroupQueryImpl;
import org.activiti5.engine.impl.NativeUserQueryImpl;
import org.activiti5.engine.impl.ServiceImpl;
import org.activiti5.engine.impl.cmd.CheckPassword;
import org.activiti5.engine.impl.cmd.CreateGroupCmd;
import org.activiti5.engine.impl.cmd.CreateGroupQueryCmd;
import org.activiti5.engine.impl.cmd.CreateMembershipCmd;
import org.activiti5.engine.impl.cmd.CreateUserCmd;
import org.activiti5.engine.impl.cmd.CreateUserQueryCmd;
import org.activiti5.engine.impl.cmd.DeleteGroupCmd;
import org.activiti5.engine.impl.cmd.DeleteMembershipCmd;
import org.activiti5.engine.impl.cmd.DeleteUserCmd;
import org.activiti5.engine.impl.cmd.DeleteUserInfoCmd;
import org.activiti5.engine.impl.cmd.GetUserInfoCmd;
import org.activiti5.engine.impl.cmd.GetUserInfoKeysCmd;
import org.activiti5.engine.impl.cmd.GetUserPictureCmd;
import org.activiti5.engine.impl.cmd.SaveGroupCmd;
import org.activiti5.engine.impl.cmd.SaveUserCmd;
import org.activiti5.engine.impl.cmd.SetUserInfoCmd;
import org.activiti5.engine.impl.cmd.SetUserPictureCmd;
import org.activiti5.engine.impl.identity.Authentication;

public class IdentityServiceImpl
extends ServiceImpl
implements IdentityService {
    @Override
    public Group newGroup(String groupId) {
        return this.commandExecutor.execute(new CreateGroupCmd(groupId));
    }

    @Override
    public User newUser(String userId) {
        return this.commandExecutor.execute(new CreateUserCmd(userId));
    }

    @Override
    public void saveGroup(Group group) {
        this.commandExecutor.execute(new SaveGroupCmd(group));
    }

    @Override
    public void saveUser(User user) {
        this.commandExecutor.execute(new SaveUserCmd(user));
    }

    @Override
    public UserQuery createUserQuery() {
        return this.commandExecutor.execute(new CreateUserQueryCmd());
    }

    @Override
    public NativeUserQuery createNativeUserQuery() {
        return new NativeUserQueryImpl(this.commandExecutor);
    }

    @Override
    public GroupQuery createGroupQuery() {
        return this.commandExecutor.execute(new CreateGroupQueryCmd());
    }

    @Override
    public NativeGroupQuery createNativeGroupQuery() {
        return new NativeGroupQueryImpl(this.commandExecutor);
    }

    @Override
    public void createMembership(String userId, String groupId) {
        this.commandExecutor.execute(new CreateMembershipCmd(userId, groupId));
    }

    @Override
    public void deleteGroup(String groupId) {
        this.commandExecutor.execute(new DeleteGroupCmd(groupId));
    }

    @Override
    public void deleteMembership(String userId, String groupId) {
        this.commandExecutor.execute(new DeleteMembershipCmd(userId, groupId));
    }

    @Override
    public boolean checkPassword(String userId, String password) {
        return this.commandExecutor.execute(new CheckPassword(userId, password));
    }

    @Override
    public void deleteUser(String userId) {
        this.commandExecutor.execute(new DeleteUserCmd(userId));
    }

    @Override
    public void setUserPicture(String userId, Picture picture) {
        this.commandExecutor.execute(new SetUserPictureCmd(userId, picture));
    }

    @Override
    public Picture getUserPicture(String userId) {
        return this.commandExecutor.execute(new GetUserPictureCmd(userId));
    }

    @Override
    public void setAuthenticatedUserId(String authenticatedUserId) {
        Authentication.setAuthenticatedUserId(authenticatedUserId);
    }

    @Override
    public String getUserInfo(String userId, String key) {
        return this.commandExecutor.execute(new GetUserInfoCmd(userId, key));
    }

    @Override
    public List<String> getUserInfoKeys(String userId) {
        return this.commandExecutor.execute(new GetUserInfoKeysCmd(userId, "userinfo"));
    }

    @Override
    public void setUserInfo(String userId, String key, String value) {
        this.commandExecutor.execute(new SetUserInfoCmd(userId, key, value));
    }

    @Override
    public void deleteUserInfo(String userId, String key) {
        this.commandExecutor.execute(new DeleteUserInfoCmd(userId, key));
    }
}

