/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti5.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.impl.pvm.PvmTransition;
import org.activiti5.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti5.engine.impl.pvm.process.ActivityImpl;

public class BoundaryEventActivityBehavior
extends FlowNodeActivityBehavior {
    protected boolean interrupting;
    protected String activityId;

    public BoundaryEventActivityBehavior() {
    }

    public BoundaryEventActivityBehavior(boolean interrupting, String activityId) {
        this.interrupting = interrupting;
        this.activityId = activityId;
    }

    @Override
    public void execute(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        ActivityImpl boundaryActivity = executionEntity.getProcessDefinition().findActivity(this.activityId);
        ActivityImpl interruptedActivity = executionEntity.getActivity();
        List<PvmTransition> outgoingTransitions = boundaryActivity.getOutgoingTransitions();
        ArrayList<ActivityExecution> interruptedExecutions = null;
        if (this.interrupting) {
            if (executionEntity.getSubProcessInstance() != null) {
                executionEntity.getSubProcessInstance().deleteCascade(executionEntity.getDeleteReason());
            } else {
                Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity);
            }
            executionEntity.setActivity(boundaryActivity);
            interruptedExecutions = new ArrayList<ActivityExecution>(executionEntity.getExecutions());
            for (ExecutionEntity executionEntity2 : interruptedExecutions) {
                executionEntity2.deleteCascade("interrupting boundary event '" + executionEntity.getActivity().getId() + "' fired");
            }
            executionEntity.takeAll(outgoingTransitions, interruptedExecutions);
        } else {
            ExecutionEntity concurrentRoot = executionEntity.getParent().isConcurrent() ? executionEntity.getParent() : executionEntity;
            ExecutionEntity executionEntity3 = concurrentRoot.createExecution();
            executionEntity3.setActive(true);
            executionEntity3.setScope(false);
            executionEntity3.setConcurrent(true);
            executionEntity3.takeAll(outgoingTransitions, Collections.EMPTY_LIST);
            executionEntity3.remove();
            executionEntity.setActivity(interruptedActivity);
        }
    }

    public boolean isInterrupting() {
        return this.interrupting;
    }

    public void setInterrupting(boolean interrupting) {
        this.interrupting = interrupting;
    }
}

