/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;

public class AddIdentityLinkForProcessInstanceCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String userId;
    protected String groupId;
    protected String type;

    public AddIdentityLinkForProcessInstanceCmd(String processInstanceId, String userId, String groupId, String type) {
        this.validateParams(processInstanceId, userId, groupId, type);
        this.processInstanceId = processInstanceId;
        this.userId = userId;
        this.groupId = groupId;
        this.type = type;
    }

    protected void validateParams(String processInstanceId, String userId, String groupId, String type) {
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("processInstanceId is null");
        }
        if (type == null) {
            throw new ActivitiIllegalArgumentException("type is required when adding a new process instance identity link");
        }
        if (userId == null && groupId == null) {
            throw new ActivitiIllegalArgumentException("userId and groupId cannot both be null");
        }
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntity processInstance = commandContext.getExecutionEntityManager().findExecutionById(this.processInstanceId);
        if (processInstance == null) {
            throw new ActivitiObjectNotFoundException("Cannot find process instance with id " + this.processInstanceId, ExecutionEntity.class);
        }
        processInstance.addIdentityLink(this.userId, this.groupId, this.type);
        commandContext.getHistoryManager().createProcessInstanceIdentityLinkComment(this.processInstanceId, this.userId, this.groupId, this.type, true);
        return null;
    }
}

