/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.form.TaskFormData;
import org.activiti5.engine.impl.form.TaskFormHandler;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.TaskEntity;
import org.activiti5.engine.task.Task;

public class GetTaskFormCmd
implements Command<TaskFormData>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetTaskFormCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public TaskFormData execute(CommandContext commandContext) {
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ActivitiObjectNotFoundException("No task found for taskId '" + this.taskId + "'", Task.class);
        }
        if (task.getTaskDefinition() != null) {
            TaskFormHandler taskFormHandler = task.getTaskDefinition().getTaskFormHandler();
            if (taskFormHandler == null) {
                throw new ActivitiException("No taskFormHandler specified for task '" + this.taskId + "'");
            }
            return taskFormHandler.createTaskForm(task);
        }
        return null;
    }
}

