/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.persistence.deploy;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.util.InputStreamProvider;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventDispatcher;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.ProcessDefinitionQueryImpl;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.persistence.deploy.Deployer;
import org.activiti5.engine.impl.persistence.deploy.ProcessDefinitionInfoCache;
import org.activiti5.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti5.engine.impl.persistence.entity.DeploymentEntityManager;
import org.activiti5.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti5.engine.impl.persistence.entity.ResourceEntity;
import org.activiti5.engine.impl.util.io.BytesStreamSource;
import org.activiti5.engine.repository.Deployment;

public class DeploymentManager {
    protected DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache;
    protected DeploymentCache<BpmnModel> bpmnModelCache;
    protected ProcessDefinitionInfoCache processDefinitionInfoCache;
    protected DeploymentCache<Object> knowledgeBaseCache;
    protected List<Deployer> deployers;

    public void deploy(DeploymentEntity deployment) {
        this.deploy(deployment, null);
    }

    public void deploy(DeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        for (Deployer deployer : this.deployers) {
            deployer.deploy(deployment, deploymentSettings);
        }
    }

    public ProcessDefinition findDeployedProcessDefinitionById(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new ActivitiIllegalArgumentException("Invalid process definition id : null");
        }
        ProcessDefinitionCacheEntry cacheEntry = (ProcessDefinitionCacheEntry)this.processDefinitionCache.get(processDefinitionId);
        ProcessDefinition processDefinition = null;
        if (cacheEntry == null) {
            processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionById(processDefinitionId);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("no deployed process definition found with id '" + processDefinitionId + "'", ProcessDefinition.class);
            }
            processDefinition = this.resolveProcessDefinition(processDefinition).getProcessDefinition();
        } else {
            processDefinition = cacheEntry.getProcessDefinition();
        }
        return processDefinition;
    }

    public ProcessDefinitionEntity findProcessDefinitionByIdFromDatabase(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new ActivitiIllegalArgumentException("Invalid process definition id : null");
        }
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionById(processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("no deployed process definition found with id '" + processDefinitionId + "'", ProcessDefinition.class);
        }
        return processDefinition;
    }

    public boolean isProcessDefinitionSuspended(String processDefinitionId) {
        return this.findProcessDefinitionByIdFromDatabase(processDefinitionId).isSuspended();
    }

    public BpmnModel getBpmnModelById(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new ActivitiIllegalArgumentException("Invalid process definition id : null");
        }
        BpmnModel bpmnModel = (BpmnModel)this.bpmnModelCache.get(processDefinitionId);
        if (bpmnModel == null) {
            ProcessDefinition processDefinition = this.findDeployedProcessDefinitionById(processDefinitionId);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("no deployed process definition found with id '" + processDefinitionId + "'", ProcessDefinition.class);
            }
            String resourceName = processDefinition.getResourceName();
            ResourceEntity resource = Context.getCommandContext().getResourceEntityManager().findResourceByDeploymentIdAndResourceName(processDefinition.getDeploymentId(), resourceName);
            if (resource == null) {
                if (Context.getCommandContext().getDeploymentEntityManager().findDeploymentById(processDefinition.getDeploymentId()) == null) {
                    throw new ActivitiObjectNotFoundException("deployment for process definition does not exist: " + processDefinition.getDeploymentId(), Deployment.class);
                }
                throw new ActivitiObjectNotFoundException("no resource found with name '" + resourceName + "' in deployment '" + processDefinition.getDeploymentId() + "'", InputStream.class);
            }
            BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
            bpmnModel = bpmnXMLConverter.convertToBpmnModel((InputStreamProvider)new BytesStreamSource(resource.getBytes()), false, false);
            this.bpmnModelCache.add(processDefinition.getId(), (Object)bpmnModel);
        }
        return bpmnModel;
    }

    public ProcessDefinition findDeployedLatestProcessDefinitionByKey(String processDefinitionKey) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findLatestProcessDefinitionByKey(processDefinitionKey);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("no processes deployed with key '" + processDefinitionKey + "'", ProcessDefinition.class);
        }
        processDefinition = this.resolveProcessDefinition(processDefinition).getProcessDefinition();
        return processDefinition;
    }

    public ProcessDefinition findDeployedLatestProcessDefinitionByKeyAndTenantId(String processDefinitionKey, String tenantId) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, tenantId);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("no processes deployed with key '" + processDefinitionKey + "' for tenant identifier '" + tenantId + "'", ProcessDefinition.class);
        }
        processDefinition = this.resolveProcessDefinition(processDefinition).getProcessDefinition();
        return processDefinition;
    }

    public ProcessDefinition findDeployedProcessDefinitionByKeyAndVersion(String processDefinitionKey, Integer processDefinitionVersion) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionByKeyAndVersion(processDefinitionKey, processDefinitionVersion);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("no processes deployed with key = '" + processDefinitionKey + "' and version = '" + processDefinitionVersion + "'", ProcessDefinition.class);
        }
        processDefinition = this.resolveProcessDefinition(processDefinition).getProcessDefinition();
        return processDefinition;
    }

    public ProcessDefinitionCacheEntry resolveProcessDefinition(ProcessDefinition processDefinition) {
        String processDefinitionId = processDefinition.getId();
        String deploymentId = processDefinition.getDeploymentId();
        ProcessDefinitionCacheEntry cachedProcessDefinition = (ProcessDefinitionCacheEntry)this.processDefinitionCache.get(processDefinitionId);
        if (cachedProcessDefinition == null) {
            DeploymentEntity deployment = Context.getCommandContext().getDeploymentEntityManager().findDeploymentById(deploymentId);
            deployment.setNew(false);
            this.deploy(deployment, null);
            cachedProcessDefinition = (ProcessDefinitionCacheEntry)this.processDefinitionCache.get(processDefinitionId);
            if (cachedProcessDefinition == null) {
                throw new ActivitiException("deployment '" + deploymentId + "' didn't put process definition '" + processDefinitionId + "' in the cache");
            }
        }
        return cachedProcessDefinition;
    }

    public void removeDeployment(String deploymentId, boolean cascade) {
        DeploymentEntityManager deploymentEntityManager = Context.getCommandContext().getDeploymentEntityManager();
        DeploymentEntity deployment = deploymentEntityManager.findDeploymentById(deploymentId);
        if (deployment == null) {
            throw new ActivitiObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.", DeploymentEntity.class);
        }
        List processDefinitions = new ProcessDefinitionQueryImpl(Context.getCommandContext()).deploymentId(deploymentId).list();
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        for (ProcessDefinition processDefinition : processDefinitions) {
            if (!eventDispatcher.isEnabled()) continue;
            eventDispatcher.dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, processDefinition));
        }
        deploymentEntityManager.deleteDeployment(deploymentId, cascade);
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, deployment));
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            this.processDefinitionCache.remove(processDefinition.getId());
        }
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    public DeploymentCache<ProcessDefinitionCacheEntry> getProcessDefinitionCache() {
        return this.processDefinitionCache;
    }

    public void setProcessDefinitionCache(DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache) {
        this.processDefinitionCache = processDefinitionCache;
    }

    public DeploymentCache<BpmnModel> getBpmnModelCache() {
        return this.bpmnModelCache;
    }

    public void setBpmnModelCache(DeploymentCache<BpmnModel> bpmnModelCache) {
        this.bpmnModelCache = bpmnModelCache;
    }

    public ProcessDefinitionInfoCache getProcessDefinitionInfoCache() {
        return this.processDefinitionInfoCache;
    }

    public void setProcessDefinitionInfoCache(ProcessDefinitionInfoCache processDefinitionInfoCache) {
        this.processDefinitionInfoCache = processDefinitionInfoCache;
    }

    public DeploymentCache<Object> getKnowledgeBaseCache() {
        return this.knowledgeBaseCache;
    }

    public void setKnowledgeBaseCache(DeploymentCache<Object> knowledgeBaseCache) {
        this.knowledgeBaseCache = knowledgeBaseCache;
    }
}

