/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.runtime.Job;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.JobQueryImpl;
import org.activiti5.engine.impl.Page;
import org.activiti5.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.jobexecutor.AsyncJobAddedNotification;
import org.activiti5.engine.impl.persistence.AbstractManager;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.impl.persistence.entity.JobEntity;
import org.activiti5.engine.impl.persistence.entity.TimerJobEntity;

public class JobEntityManager
extends AbstractManager {
    public void send(JobEntity message) {
        message.insert();
        if (Context.getProcessEngineConfiguration().getAsyncExecutor().isActive()) {
            this.hintAsyncExecutor(message);
        }
    }

    public void schedule(TimerJobEntity timer) {
        Date duedate = timer.getDuedate();
        if (duedate == null) {
            throw new ActivitiIllegalArgumentException("duedate is null");
        }
        timer.insert();
    }

    protected void hintAsyncExecutor(Job job) {
        AsyncExecutor asyncExecutor = Context.getProcessEngineConfiguration().getAsyncExecutor();
        AsyncJobAddedNotification commandContextCloseListener = new AsyncJobAddedNotification(job, asyncExecutor);
        Context.getCommandContext().addCloseListener(commandContextCloseListener);
    }

    public void cancelTimers(ExecutionEntity execution) {
        List<TimerJobEntity> timers = Context.getCommandContext().getJobEntityManager().findTimersByExecutionId(execution.getId());
        for (TimerJobEntity timer : timers) {
            if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, timer));
            }
            timer.delete();
        }
    }

    public JobEntity findJobById(String jobId) {
        return (JobEntity)this.getDbSqlSession().selectOne("selectJob", jobId);
    }

    public List<JobEntity> findNextJobsToExecute(Page page) {
        ProcessEngineConfigurationImpl processEngineConfig = Context.getProcessEngineConfiguration();
        Date now = processEngineConfig.getClock().getCurrentTime();
        return this.getDbSqlSession().selectList("selectNextJobsToExecute", now, page);
    }

    public List<JobEntity> findJobsByLockOwner(String lockOwner, int start, int maxNrOfJobs) {
        return this.getDbSqlSession().selectList("selectJobsByLockOwner", lockOwner, start, maxNrOfJobs);
    }

    public List<JobEntity> findJobsByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectJobsByExecutionId", executionId);
    }

    public List<JobEntity> findJobsByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectJobsByProcessInstanceId", processInstanceId);
    }

    public List<JobEntity> findExclusiveJobsToExecute(String processInstanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", processInstanceId);
        params.put("now", Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        return this.getDbSqlSession().selectList("selectExclusiveJobsToExecute", params);
    }

    public List<TimerJobEntity> findUnlockedTimersByDuedate(Date duedate, Page page) {
        String query = "selectUnlockedTimersByDuedate";
        return this.getDbSqlSession().selectList("selectUnlockedTimersByDuedate", duedate, page);
    }

    public List<TimerJobEntity> findTimersByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectTimersByExecutionId", executionId);
    }

    public List<Job> findJobsByQueryCriteria(JobQueryImpl jobQuery, Page page) {
        String query = "selectJobByQueryCriteria";
        return this.getDbSqlSession().selectList("selectJobByQueryCriteria", jobQuery, page);
    }

    public List<Job> findJobsByTypeAndProcessDefinitionKeyNoTenantId(String jobHandlerType, String processDefinitionKey) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("handlerType", jobHandlerType);
        params.put("processDefinitionKey", processDefinitionKey);
        return this.getDbSqlSession().selectList("selectJobByTypeAndProcessDefinitionKeyNoTenantId", params);
    }

    public List<Job> findJobsByTypeAndProcessDefinitionKeyAndTenantId(String jobHandlerType, String processDefinitionKey, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("handlerType", jobHandlerType);
        params.put("processDefinitionKey", processDefinitionKey);
        params.put("tenantId", tenantId);
        return this.getDbSqlSession().selectList("selectJobByTypeAndProcessDefinitionKeyAndTenantId", params);
    }

    public List<Job> findJobsByTypeAndProcessDefinitionId(String jobHandlerType, String processDefinitionId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("handlerType", jobHandlerType);
        params.put("processDefinitionId", processDefinitionId);
        return this.getDbSqlSession().selectList("selectJobByTypeAndProcessDefinitionId", params);
    }

    public void unacquireJob(String jobId) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("id", jobId);
        params.put("dueDate", new Date(this.getProcessEngineConfiguration().getClock().getCurrentTime().getTime()));
        this.getDbSqlSession().update("unacquireJob", params);
    }

    public long findJobCountByQueryCriteria(JobQueryImpl jobQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectJobCountByQueryCriteria", jobQuery);
    }

    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateJobTenantIdForDeployment", params);
    }

    public int updateJobLockForAllJobs(String lockOwner, Date expirationTime) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("lockOwner", lockOwner);
        params.put("lockExpirationTime", expirationTime);
        params.put("dueDate", Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        return this.getDbSqlSession().update("updateJobLockForAllJobs", params);
    }
}

