/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.pvm.runtime;

import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.impl.delegate.ActivityBehavior;
import org.activiti5.engine.ActivitiActivityExecutionException;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.pvm.PvmException;
import org.activiti5.engine.impl.pvm.process.ActivityImpl;
import org.activiti5.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti5.engine.impl.pvm.runtime.InterpretableExecution;
import org.activiti5.engine.logging.LogMDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicOperationActivityExecute
implements AtomicOperation {
    private static Logger log = LoggerFactory.getLogger(AtomicOperationActivityExecute.class);

    @Override
    public boolean isAsync(InterpretableExecution execution) {
        return false;
    }

    @Override
    public void execute(InterpretableExecution execution) {
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        ActivityBehavior activityBehavior = activity.getActivityBehavior();
        if (activityBehavior == null) {
            throw new PvmException("no behavior specified in " + activity);
        }
        log.debug("{} executes {}: {}", new Object[]{execution, activity, activityBehavior.getClass().getName()});
        try {
            if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createActivityEvent(ActivitiEventType.ACTIVITY_STARTED, execution.getActivity().getId(), (String)execution.getActivity().getProperty("name"), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), (String)activity.getProperties().get("type"), activity.getActivityBehavior().getClass().getCanonicalName()));
            }
            activityBehavior.execute((DelegateExecution)execution);
        }
        catch (ActivitiException e) {
            throw e;
        }
        catch (Throwable t) {
            LogMDC.putMDCExecution(execution);
            throw new ActivitiActivityExecutionException("couldn't execute activity <" + activity.getProperty("type") + " id=\"" + activity.getId() + "\" ...>: " + t.getMessage(), t);
        }
    }
}

