/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.variable;

import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.variable.CacheableVariable;
import org.activiti5.engine.impl.variable.EntityManagerSession;
import org.activiti5.engine.impl.variable.JPAEntityMappings;

public class JPAEntityVariableType
implements VariableType,
CacheableVariable {
    public static final String TYPE_NAME = "jpa-entity";
    private JPAEntityMappings mappings = new JPAEntityMappings();
    private boolean forceCacheable = false;

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return this.forceCacheable;
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return this.mappings.isJPAEntity(value);
    }

    public void setValue(Object value, ValueFields valueFields) {
        EntityManagerSession entityManagerSession = Context.getCommandContext().getSession(EntityManagerSession.class);
        if (entityManagerSession == null) {
            throw new ActivitiException("Cannot set JPA variable: " + EntityManagerSession.class + " not configured");
        }
        entityManagerSession.flush();
        if (value != null) {
            String className = this.mappings.getJPAClassString(value);
            String idString = this.mappings.getJPAIdString(value);
            valueFields.setTextValue(className);
            valueFields.setTextValue2(idString);
        } else {
            valueFields.setTextValue(null);
            valueFields.setTextValue2(null);
        }
    }

    public Object getValue(ValueFields valueFields) {
        if (valueFields.getTextValue() != null && valueFields.getTextValue2() != null) {
            return this.mappings.getJPAEntity(valueFields.getTextValue(), valueFields.getTextValue2());
        }
        return null;
    }

    @Override
    public void setForceCacheable(boolean forceCachedValue) {
        this.forceCacheable = forceCachedValue;
    }
}

