/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.store.db;

import javax.sql.DataSource;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.executor.Initialize;
import org.apache.seata.common.util.ConfigTools;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.constants.DBType;
import org.apache.seata.core.store.db.DataSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceProvider
implements DataSourceProvider,
Initialize {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataSourceProvider.class);
    private DataSource dataSource;
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static final long DEFAULT_DB_MAX_WAIT = 5000L;

    @Override
    public void init() {
        this.dataSource = this.generate();
    }

    @Override
    public DataSource provide() {
        return this.dataSource;
    }

    public DataSource generate() {
        this.validate();
        return this.doGenerate();
    }

    public void validate() {
        String driverClassName = this.getDriverClassName();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (null == loader) {
            throw new StoreException("class loader set error, you should not use the Bootstrap classloader");
        }
        try {
            loader.loadClass(driverClassName);
        }
        catch (ClassNotFoundException exx) {
            String driverClassPath = null;
            String folderPath = System.getProperty("loader.path");
            if (null != folderPath) {
                driverClassPath = folderPath + "/jdbc/";
            }
            throw new StoreException(String.format("The driver {%s} cannot be found in the path %s. Please ensure that the appropriate database driver dependencies are included in the classpath.", driverClassName, driverClassPath));
        }
    }

    public abstract DataSource doGenerate();

    protected DBType getDBType() {
        return DBType.valueof(CONFIG.getConfig("store.db.dbType"));
    }

    protected String getDriverClassName() {
        String driverClassName = CONFIG.getConfig("store.db.driverClassName");
        if (StringUtils.isBlank(driverClassName)) {
            throw new StoreException(String.format("the {%s} can't be empty", "store.db.driverClassName"));
        }
        return driverClassName;
    }

    protected Long getMaxWait() {
        Long maxWait = CONFIG.getLong("store.db.maxWait", 5000L);
        return maxWait;
    }

    protected ClassLoader getDriverClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    protected String getUrl() {
        String url = CONFIG.getConfig("store.db.url");
        if (StringUtils.isBlank(url)) {
            throw new StoreException(String.format("the {%s} can't be empty", "store.db.url"));
        }
        return url;
    }

    protected String getUser() {
        String user = CONFIG.getConfig("store.db.user");
        if (StringUtils.isBlank(user)) {
            throw new StoreException(String.format("the {%s} can't be empty", "store.db.user"));
        }
        return user;
    }

    protected String getPassword() {
        String password = CONFIG.getConfig("store.db.password");
        String publicKey = this.getPublicKey();
        if (StringUtils.isNotBlank(publicKey)) {
            try {
                password = ConfigTools.publicDecrypt(password, publicKey);
            }
            catch (Exception e) {
                LOGGER.error("decryption failed,please confirm whether the ciphertext and secret key are correct! error msg: {}", (Object)e.getMessage());
            }
        }
        return password;
    }

    protected int getMinConn() {
        int minConn = CONFIG.getInt("store.db.minConn", 10);
        return minConn < 0 ? 10 : minConn;
    }

    protected int getMaxConn() {
        int maxConn = CONFIG.getInt("store.db.maxConn", 100);
        return maxConn < 0 ? 100 : maxConn;
    }

    protected String getValidationQuery(DBType dbType) {
        if (DBType.ORACLE.equals((Object)dbType)) {
            return "select sysdate from dual";
        }
        return "select 1";
    }

    protected String getPublicKey() {
        return CONFIG.getConfig("store.publicKey");
    }
}

