/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.tx.api.remoting.parser;

import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.common.util.ReflectionUtil;
import org.apache.seata.integration.tx.api.remoting.RemotingDesc;
import org.apache.seata.integration.tx.api.remoting.parser.AbstractedRemotingParser;

public class DubboRemotingParser
extends AbstractedRemotingParser {
    @Override
    public boolean isReference(Object bean, String beanName) throws FrameworkException {
        Class<?> c = bean.getClass();
        return "com.alibaba.dubbo.config.spring.ReferenceBean".equals(c.getName()) || "org.apache.dubbo.config.spring.ReferenceBean".equals(c.getName());
    }

    @Override
    public boolean isService(Object bean, String beanName) throws FrameworkException {
        Class<?> c = bean.getClass();
        return "com.alibaba.dubbo.config.spring.ServiceBean".equals(c.getName()) || "org.apache.dubbo.config.spring.ServiceBean".equals(c.getName());
    }

    @Override
    public boolean isService(Class<?> beanClass) throws FrameworkException {
        return "com.alibaba.dubbo.config.spring.ServiceBean".equals(beanClass.getName()) || "org.apache.dubbo.config.spring.ServiceBean".equals(beanClass.getName());
    }

    @Override
    public RemotingDesc getServiceDesc(Object bean, String beanName) throws FrameworkException {
        if (!this.isRemoting(bean, beanName)) {
            return null;
        }
        try {
            RemotingDesc serviceBeanDesc = new RemotingDesc();
            Class interfaceClass = (Class)ReflectionUtil.invokeMethod(bean, "getInterfaceClass");
            String interfaceClassName = (String)ReflectionUtil.getFieldValue(bean, "interfaceName");
            String version = (String)ReflectionUtil.invokeMethod(bean, "getVersion");
            String group = (String)ReflectionUtil.invokeMethod(bean, "getGroup");
            serviceBeanDesc.setServiceClass(interfaceClass);
            serviceBeanDesc.setServiceClassName(interfaceClassName);
            serviceBeanDesc.setUniqueId(version);
            serviceBeanDesc.setGroup(group);
            serviceBeanDesc.setProtocol((short)3);
            if (this.isService(bean, beanName)) {
                Object targetBean = ReflectionUtil.getFieldValue(bean, "ref");
                serviceBeanDesc.setTargetBean(targetBean);
            }
            serviceBeanDesc.setReference(this.isReference(bean, beanName));
            serviceBeanDesc.setService(this.isService(bean, beanName));
            return serviceBeanDesc;
        }
        catch (Throwable t) {
            throw new FrameworkException(t);
        }
    }

    @Override
    public short getProtocol() {
        return 3;
    }
}

