/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.proctrl.eventing.impl;

import java.util.List;
import java.util.Stack;
import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.proctrl.eventing.EventConsumer;
import org.apache.seata.saga.proctrl.eventing.impl.AbstractEventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectEventBus
extends AbstractEventBus<ProcessContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectEventBus.class);
    private static final String VAR_NAME_SYNC_EXE_STACK = "_sync_execution_stack_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(ProcessContext context) throws FrameworkException {
        List<EventConsumer> eventHandlers = this.getEventConsumers((Class)context.getClass());
        if (CollectionUtils.isEmpty(eventHandlers)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("cannot find event handler by class: " + context.getClass());
            }
            return false;
        }
        boolean isFirstEvent = false;
        Stack<ProcessContext> currentStack = (Stack<ProcessContext>)context.getVariable(VAR_NAME_SYNC_EXE_STACK);
        if (currentStack == null) {
            ProcessContext processContext = context;
            synchronized (processContext) {
                currentStack = (Stack)context.getVariable(VAR_NAME_SYNC_EXE_STACK);
                if (currentStack == null) {
                    currentStack = new Stack<ProcessContext>();
                    context.setVariable(VAR_NAME_SYNC_EXE_STACK, currentStack);
                    isFirstEvent = true;
                }
            }
        }
        currentStack.push(context);
        if (isFirstEvent) {
            try {
                while (currentStack.size() > 0) {
                    ProcessContext currentContext = (ProcessContext)currentStack.pop();
                    for (EventConsumer eventHandler : eventHandlers) {
                        eventHandler.process(currentContext);
                    }
                }
            }
            finally {
                context.removeVariable(VAR_NAME_SYNC_EXE_STACK);
            }
        }
        return true;
    }
}

