/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.BetaConstraints;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.util.index.IndexUtil;
import org.kie.internal.conf.IndexPrecedenceOption;

public abstract class MultipleBetaConstraint
implements BetaConstraints {
    protected BetaNodeFieldConstraint[] constraints;
    protected boolean[] indexed;
    protected IndexPrecedenceOption indexPrecedenceOption;
    protected transient boolean disableIndexing;
    private transient Boolean leftUpdateOptimizationAllowed;

    public MultipleBetaConstraint() {
    }

    public MultipleBetaConstraint(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf, boolean disableIndexing) {
        this(constraints, conf.getIndexPrecedenceOption(), disableIndexing);
    }

    protected MultipleBetaConstraint(BetaNodeFieldConstraint[] constraints, IndexPrecedenceOption indexPrecedenceOption, boolean disableIndexing) {
        this.constraints = constraints;
        this.indexPrecedenceOption = indexPrecedenceOption;
        this.disableIndexing = disableIndexing;
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraints = (BetaNodeFieldConstraint[])in.readObject();
        this.indexed = (boolean[])in.readObject();
        this.indexPrecedenceOption = (IndexPrecedenceOption)in.readObject();
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.constraints);
        out.writeObject(this.indexed);
        out.writeObject(this.indexPrecedenceOption);
    }

    @Override
    public final void init(BuildContext context, short betaNodeType) {
        RuleBaseConfiguration config = context.getKnowledgeBase().getConfiguration();
        if (this.disableIndexing || !config.isIndexLeftBetaMemory() && !config.isIndexRightBetaMemory()) {
            this.indexed = new boolean[this.constraints.length];
        } else {
            int depth = config.getCompositeKeyDepth();
            if (!IndexUtil.compositeAllowed(this.constraints, betaNodeType, config)) {
                depth = 1;
            }
            this.initIndexes(depth, betaNodeType, config);
        }
    }

    @Override
    public final void initIndexes(int depth, short betaNodeType, RuleBaseConfiguration config) {
        this.indexed = IndexUtil.isIndexableForNode(this.indexPrecedenceOption, betaNodeType, depth, this.constraints, config);
    }

    @Override
    public final boolean isIndexed() {
        return this.indexed[0];
    }

    @Override
    public final int getIndexCount() {
        int count = 0;
        for (boolean i : this.indexed) {
            if (!i) continue;
            ++count;
        }
        return count;
    }

    @Override
    public BetaMemory createBetaMemory(RuleBaseConfiguration config, short nodeType) {
        return IndexUtil.Factory.createBetaMemory(config, nodeType, this.constraints);
    }

    @Override
    public final BetaNodeFieldConstraint[] getConstraints() {
        return this.constraints;
    }

    @Override
    public final ContextEntry[] createContext() {
        ContextEntry[] entries = new ContextEntry[this.constraints.length];
        for (int i = 0; i < this.constraints.length; ++i) {
            entries[i] = this.constraints[i].createContextEntry();
        }
        return entries;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isLeftUpdateOptimizationAllowed() {
        if (this.leftUpdateOptimizationAllowed == null) {
            this.leftUpdateOptimizationAllowed = this.calcLeftUpdateOptimizationAllowed();
        }
        return this.leftUpdateOptimizationAllowed;
    }

    private boolean calcLeftUpdateOptimizationAllowed() {
        for (BetaNodeFieldConstraint constraint : this.constraints) {
            if (constraint instanceof IndexableConstraint && ((IndexableConstraint)((Object)constraint)).getConstraintType().isEquality()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void registerEvaluationContext(BuildContext buildContext) {
        for (int i = 0; i < this.constraints.length; ++i) {
            this.constraints[i].registerEvaluationContext(buildContext);
        }
    }
}

