/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataImpl;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class CGlobalDataFeature
implements GraalFeature {
    private Map<CGlobalDataImpl<?>, CGlobalDataInfo> map = new ConcurrentHashMap();
    private int totalSize = -1;

    public static CGlobalDataFeature singleton() {
        return (CGlobalDataFeature)ImageSingletons.lookup(CGlobalDataFeature.class);
    }

    private boolean isLayouted() {
        return this.totalSize != -1;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(this::replaceObject);
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess access) {
        this.layout();
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, InvocationPlugins invocationPlugins, boolean analysis, boolean hosted) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(invocationPlugins, CGlobalData.class);
        r.register1("get", InvocationPlugin.Receiver.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                VMError.guarantee(receiver.get().isConstant(), "Accessed CGlobalData is not a compile-time constant: " + b.getMethod().asStackTraceElement(b.bci()));
                CGlobalDataImpl data = (CGlobalDataImpl)SubstrateObjectConstant.asObject(receiver.get().asConstant());
                CGlobalDataInfo info = (CGlobalDataInfo)CGlobalDataFeature.this.map.get(data);
                b.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)new CGlobalDataLoadAddressNode(info));
                return true;
            }
        });
    }

    public CGlobalDataInfo getCGlobalDataInfo(CGlobalDataImpl<?> data) {
        return this.map.get(data);
    }

    public CGlobalDataInfo registerAsAccessed(CGlobalData<?> obj) {
        CGlobalDataImpl data = (CGlobalDataImpl)obj;
        assert (!this.isLayouted() || this.map.containsKey(data)) : "CGlobalData instance must have been discovered/registered before or during analysis";
        return this.map.computeIfAbsent((CGlobalDataImpl)obj, o -> new CGlobalDataInfo(data));
    }

    private Object replaceObject(Object obj) {
        if (obj instanceof CGlobalDataImpl) {
            this.registerAsAccessed((CGlobalData)obj);
        }
        return obj;
    }

    private void layout() {
        assert (!this.isLayouted()) : "Already layouted";
        int wordSize = ConfigurationValues.getTarget().wordSize;
        int offset = 0;
        for (Map.Entry<CGlobalDataImpl<?>, CGlobalDataInfo> entry : this.map.entrySet()) {
            int size;
            CGlobalDataImpl<?> data = entry.getKey();
            CGlobalDataInfo info = entry.getValue();
            byte[] bytes = null;
            if (data.bytesSupplier != null) {
                bytes = data.bytesSupplier.get();
                size = bytes.length;
            } else if (data.sizeSupplier != null) {
                size = data.sizeSupplier.getAsInt();
            } else {
                assert (data.symbolName != null) : "CGlobalData without bytes, size, or referenced symbol";
                size = wordSize;
            }
            info.assign(offset, bytes);
            offset += size;
            offset = offset + (wordSize - 1) & ~(wordSize - 1);
        }
        this.totalSize = offset;
        assert (this.isLayouted());
    }

    public int getSize() {
        assert (this.isLayouted()) : "Not layouted yet";
        return this.totalSize;
    }

    public void writeData(RelocatableBuffer buffer, BiFunction<Integer, String, ?> createSymbol) {
        assert (this.isLayouted()) : "Not layouted yet";
        int start = buffer.getPosition();
        assert (IntStream.range(0, this.totalSize).allMatch(i -> buffer.getByte(i) == 0)) : "Buffer must be zero-initialized";
        for (CGlobalDataInfo info : this.map.values()) {
            byte[] bytes = info.getBytes();
            if (bytes != null) {
                buffer.setPosition(start + info.getOffset());
                buffer.putBytes(bytes, 0, bytes.length);
            }
            CGlobalDataImpl<?> data = info.getData();
            if (data.symbolName == null || info.isSymbolReference()) continue;
            createSymbol.apply(info.getOffset(), data.symbolName);
        }
    }
}

