/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;

public class AnalysisMethodCalleeWalker {
    private final List<AnalysisMethod> path = new ArrayList<AnalysisMethod>();

    public boolean walkMethod(AnalysisMethod method, CallPathVisitor visitor) {
        if (visitor.prologue() != CallPathVisitor.VisitResult.CONTINUE) {
            return false;
        }
        this.path.clear();
        this.walkMethodAndCallees(method, null, null, visitor);
        CallPathVisitor.VisitResult epilogueResult = visitor.epilogue();
        return epilogueResult != CallPathVisitor.VisitResult.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CallPathVisitor.VisitResult walkMethodAndCallees(AnalysisMethod method, AnalysisMethod caller, Invoke invoke, CallPathVisitor visitor) {
        if (this.path.contains(method)) {
            return CallPathVisitor.VisitResult.CUT;
        }
        this.path.add(method);
        try {
            CallPathVisitor.VisitResult directResult = visitor.visitMethod(method, caller, invoke, this.path.size());
            if (directResult != CallPathVisitor.VisitResult.CONTINUE) {
                CallPathVisitor.VisitResult visitResult = directResult;
                return visitResult;
            }
            CallPathVisitor.VisitResult calleeResult = this.walkCallees(method, visitor);
            if (calleeResult != CallPathVisitor.VisitResult.CONTINUE) {
                CallPathVisitor.VisitResult visitResult = calleeResult;
                return visitResult;
            }
            for (AnalysisMethod impl : method.getImplementations()) {
                this.walkMethodAndCallees(impl, caller, invoke, visitor);
            }
            CallPathVisitor.VisitResult visitResult = CallPathVisitor.VisitResult.CONTINUE;
            return visitResult;
        }
        finally {
            this.path.remove(method);
        }
    }

    CallPathVisitor.VisitResult walkCallees(AnalysisMethod method, CallPathVisitor visitor) {
        StructuredGraph graph = method.getTypeFlow().getGraph();
        if (graph != null) {
            for (Invoke invoke : graph.getInvokes()) {
                CallTargetNode callTarget = invoke.callTarget();
                AnalysisMethod callee = (AnalysisMethod)callTarget.targetMethod();
                this.walkMethodAndCallees(callee, method, invoke, visitor);
            }
        }
        return CallPathVisitor.VisitResult.CONTINUE;
    }

    static abstract class CallPathVisitor {
        CallPathVisitor() {
        }

        public VisitResult prologue() {
            return VisitResult.CONTINUE;
        }

        public abstract VisitResult visitMethod(AnalysisMethod var1, AnalysisMethod var2, Invoke var3, int var4);

        public VisitResult epilogue() {
            return VisitResult.CONTINUE;
        }

        void printPath(PrintStream trace, List<AnalysisMethod> path) {
            trace.print("  [Path: ");
            for (AnalysisMethod element : path) {
                trace.println();
                trace.print("     " + element.format("%h.%n(%p)"));
            }
            trace.println("]");
        }

        public static enum VisitResult {
            CONTINUE,
            CUT,
            QUIT;

        }
    }
}

