/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.config.server.exception.NacosConfigException;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoBetaWrapper;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.model.event.DerbyImportEvent;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.service.repository.embedded.EmbeddedPaginationHelperImpl;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoBetaMapper;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Service(value="embeddedConfigInfoBetaPersistServiceImpl")
public class EmbeddedConfigInfoBetaPersistServiceImpl
implements ConfigInfoBetaPersistService {
    private DataSourceService dataSourceService;
    private final DatabaseOperate databaseOperate;
    private MapperManager mapperManager;

    public EmbeddedConfigInfoBetaPersistServiceImpl(DatabaseOperate databaseOperate) {
        this.databaseOperate = databaseOperate;
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        NotifyCenter.registerToSharePublisher(DerbyImportEvent.class);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new EmbeddedPaginationHelperImpl(this.databaseOperate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfigInfo4Beta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String encryptedDataKey = StringUtils.isBlank((CharSequence)configInfo.getEncryptedDataKey()) ? "" : configInfo.getEncryptedDataKey();
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
            String sql = configInfoBetaMapper.insert(Arrays.asList("data_id", "group_id", "tenant_id", "app_name", "content", "md5", "beta_ips", "src_ip", "src_user", "gmt_create", "gmt_modified", "encrypted_data_key"));
            Object[] args = new Object[]{configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5, betaIps, srcIp, srcUser, time, time, encryptedDataKey};
            EmbeddedStorageContextUtils.onModifyConfigBetaInfo(configInfo, betaIps, srcIp, time);
            EmbeddedStorageContextUtils.addSqlContext(sql, args);
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public void insertOrUpdateBeta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        if (this.findConfigInfo4Beta(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()) == null) {
            this.addConfigInfo4Beta(configInfo, betaIps, srcIp, null, time, notify);
        } else {
            this.updateConfigInfo4Beta(configInfo, betaIps, srcIp, null, time, notify);
        }
    }

    @Override
    public boolean insertOrUpdateBetaCas(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        if (this.findConfigInfo4Beta(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()) == null) {
            this.addConfigInfo4Beta(configInfo, betaIps, srcIp, null, time, notify);
            return true;
        }
        return this.updateConfigInfo4BetaCas(configInfo, betaIps, srcIp, null, time, notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigInfo4Beta(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoBetaWrapper configInfo = this.findConfigInfo4Beta(dataId, group, tenant);
        if (configInfo != null) {
            try {
                ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
                String sql = configInfoBetaMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id"));
                Object[] args = new Object[]{dataId, group, tenantTmp};
                EmbeddedStorageContextUtils.onDeleteConfigBetaInfo(tenantTmp, group, dataId, System.currentTimeMillis());
                EmbeddedStorageContextUtils.addSqlContext(sql, args);
                boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
                if (!result) {
                    throw new NacosConfigException("[Tag] Configuration deletion failed");
                }
            }
            finally {
                EmbeddedStorageContextUtils.cleanAllContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfigInfo4Beta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String encryptedDataKey = StringUtils.isBlank((CharSequence)configInfo.getEncryptedDataKey()) ? "" : configInfo.getEncryptedDataKey();
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
            String sql = configInfoBetaMapper.update(Arrays.asList("content", "md5", "beta_ips", "src_ip", "src_user", "gmt_modified", "app_name", "encrypted_data_key"), Arrays.asList("data_id", "group_id", "tenant_id"));
            Object[] args = new Object[]{configInfo.getContent(), md5, betaIps, srcIp, srcUser, time, appNameTmp, encryptedDataKey, configInfo.getDataId(), configInfo.getGroup(), tenantTmp};
            EmbeddedStorageContextUtils.onModifyConfigBetaInfo(configInfo, betaIps, srcIp, time);
            EmbeddedStorageContextUtils.addSqlContext(sql, args);
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateConfigInfo4BetaCas(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
            String sql = configInfoBetaMapper.updateConfigInfo4BetaCas();
            Object[] args = new Object[]{configInfo.getContent(), md5, betaIps, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, configInfo.getMd5()};
            EmbeddedStorageContextUtils.onModifyConfigBetaInfo(configInfo, betaIps, srcIp, time);
            EmbeddedStorageContextUtils.addSqlContext(sql, args);
            boolean bl = this.databaseOperate.blockUpdate();
            return bl;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public ConfigInfoBetaWrapper findConfigInfo4Beta(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
        String sql = configInfoBetaMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "app_name", "content", "beta_ips", "encrypted_data_key"), Arrays.asList("data_id", "group_id", "tenant_id"));
        return this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp}, RowMapperManager.CONFIG_INFO_BETA_WRAPPER_ROW_MAPPER);
    }

    @Override
    public int configInfoBetaCount() {
        ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
        String sql = configInfoBetaMapper.count(null);
        Integer result = this.databaseOperate.queryOne(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    @Override
    public Page<ConfigInfoBetaWrapper> findAllConfigInfoBetaForDumpAll(int pageNo, int pageSize) {
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
        String sqlCountRows = configInfoBetaMapper.count(null);
        String sqlFetchRows = configInfoBetaMapper.findAllConfigInfoBetaForDumpAllFetchRows(startRow, pageSize);
        PaginationHelper<ConfigInfoBetaWrapper> helper = this.createPaginationHelper();
        return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[0], pageNo, pageSize, RowMapperManager.CONFIG_INFO_BETA_WRAPPER_ROW_MAPPER);
    }
}

