/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.tower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.builder.FirResolvedQualifierBuilder;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.ConstructorProcessingKt;
import org.jetbrains.kotlin.fir.resolve.calls.ExpressionReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.tower.ProcessResult;
import org.jetbrains.kotlin.fir.resolve.calls.tower.SessionBasedTowerLevel;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerScopeLevel;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirDefaultStarImportingScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirObjectImportedCallableScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectData;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ0\u0010\u0012\u001a\u00020\u0013\"\f\b\u0000\u0010\u0014*\u0006\u0012\u0002\b\u00030\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0019H\u0002J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\t2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u0019H\u0016J\"\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0019H\u0016J\"\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0\u0019H\u0016J\u0014\u0010#\u001a\u00020\u000b2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/ScopeTowerLevel;", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/SessionBasedTowerLevel;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "scope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "extensionReceiver", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "extensionsOnly", "", "includeInnerConstructors", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/scopes/FirScope;Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;ZZ)V", "getExtensionReceiver", "()Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "getScope", "()Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "consumeCallableCandidate", "", "T", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "candidate", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "processor", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerScopeLevel$TowerScopeLevelProcessor;", "dispatchReceiverValue", "processFunctionsByName", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/ProcessResult;", "info", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "processObjectsByName", "processPropertiesByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "shouldSkipCandidateWithInconsistentExtensionReceiver", "resolve"})
public final class ScopeTowerLevel
extends SessionBasedTowerLevel {
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @NotNull
    private final FirScope scope;
    @Nullable
    private final ReceiverValue extensionReceiver;
    private final boolean extensionsOnly;
    private final boolean includeInnerConstructors;

    public ScopeTowerLevel(@NotNull FirSession session2, @NotNull BodyResolveComponents bodyResolveComponents, @NotNull FirScope scope2, @Nullable ReceiverValue extensionReceiver, boolean extensionsOnly, boolean includeInnerConstructors) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents, (String)"bodyResolveComponents");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        super(session2);
        this.bodyResolveComponents = bodyResolveComponents;
        this.scope = scope2;
        this.extensionReceiver = extensionReceiver;
        this.extensionsOnly = extensionsOnly;
        this.includeInnerConstructors = includeInnerConstructors;
    }

    @NotNull
    public final FirScope getScope() {
        return this.scope;
    }

    @Nullable
    public final ReceiverValue getExtensionReceiver() {
        return this.extensionReceiver;
    }

    /*
     * WARNING - void declaration
     */
    private final ReceiverValue dispatchReceiverValue(FirCallableSymbol<?> candidate2) {
        ImportedFromObjectData<FirCallableDeclaration> importedFromObjectData = FirObjectImportedCallableScopeKt.getImportedFromObjectData((FirCallableDeclaration)candidate2.getFir());
        if (importedFromObjectData != null) {
            ImportedFromObjectData<FirCallableDeclaration> data = importedFromObjectData;
            boolean bl = false;
            ClassId objectClassId = data.getObjectClassId();
            FirClassLikeSymbol<?> symbol2 = FirSymbolProviderKt.getSymbolProvider(this.getSession()).getClassLikeSymbolByClassId(objectClassId);
            if (symbol2 instanceof FirRegularClassSymbol) {
                void $this$resultType$iv;
                FirResolvedQualifier firResolvedQualifier;
                FirResolvedQualifierBuilder firResolvedQualifierBuilder;
                boolean $i$f$buildResolvedQualifier = false;
                FirResolvedQualifierBuilder $this$dispatchReceiverValue_u24lambda_u2d2_u24lambda_u2d0 = firResolvedQualifierBuilder = new FirResolvedQualifierBuilder();
                boolean $i$a$-buildResolvedQualifier-ScopeTowerLevel$dispatchReceiverValue$1$resolvedQualifier$22 = false;
                FqName fqName2 = objectClassId.getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"objectClassId.packageFqName");
                $this$dispatchReceiverValue_u24lambda_u2d2_u24lambda_u2d0.setPackageFqName(fqName2);
                $this$dispatchReceiverValue_u24lambda_u2d2_u24lambda_u2d0.setRelativeClassFqName(objectClassId.getRelativeClassName());
                $this$dispatchReceiverValue_u24lambda_u2d2_u24lambda_u2d0.setSymbol(symbol2);
                FirResolvedQualifier $this$dispatchReceiverValue_u24lambda_u2d2_u24lambda_u2d1 = firResolvedQualifier = firResolvedQualifierBuilder.build();
                boolean bl2 = false;
                FirExpression $i$a$-buildResolvedQualifier-ScopeTowerLevel$dispatchReceiverValue$1$resolvedQualifier$22 = $this$dispatchReceiverValue_u24lambda_u2d2_u24lambda_u2d1;
                FirTypeRef type$iv = ResolveUtilsKt.typeForQualifier(this.bodyResolveComponents, $this$dispatchReceiverValue_u24lambda_u2d2_u24lambda_u2d1);
                boolean $i$f$setResultType = false;
                $this$resultType$iv.replaceTypeRef(type$iv);
                FirResolvedQualifier resolvedQualifier = firResolvedQualifier;
                return new ExpressionReceiverValue(resolvedQualifier);
            }
        }
        if (!(candidate2 instanceof FirBackingFieldSymbol)) {
            return null;
        }
        ConeClassLikeLookupTag lookupTag2 = ClassMembersKt.dispatchReceiverClassOrNull(((FirBackingField)((FirBackingFieldSymbol)candidate2).getFir()).getPropertySymbol());
        return lookupTag2 != null ? (ReceiverValue)this.bodyResolveComponents.getImplicitReceiverStack().lastDispatchReceiver((Function1)new Function1<ImplicitReceiverValue<?>, Boolean>(this, lookupTag2){
            final /* synthetic */ ScopeTowerLevel this$0;
            final /* synthetic */ ConeClassLikeLookupTag $lookupTag;
            {
                this.this$0 = $receiver;
                this.$lookupTag = $lookupTag;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ImplicitReceiverValue<?> implicitReceiverValue) {
                Intrinsics.checkNotNullParameter(implicitReceiverValue, (String)"implicitReceiverValue");
                ConeKotlinType coneKotlinType = implicitReceiverValue.getType();
                ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
                return Intrinsics.areEqual(coneClassLikeType != null && (coneClassLikeType = TypeExpansionUtilsKt.fullyExpandedType$default(coneClassLikeType, this.this$0.getSession(), null, 2, null)) != null ? coneClassLikeType.getLookupTag() : null, (Object)this.$lookupTag);
            }
        }) : (ReceiverValue)this.bodyResolveComponents.getImplicitReceiverStack().lastDispatchReceiver();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldSkipCandidateWithInconsistentExtensionReceiver(FirCallableSymbol<?> candidate2) {
        ConeKotlinType extensionReceiverType;
        if (this.scope instanceof FirDefaultStarImportingScope && this.extensionReceiver != null && (extensionReceiverType = this.extensionReceiver.getType()) instanceof ConeClassLikeType) {
            ConeKotlinType declarationReceiverType;
            FirTypeRef firTypeRef = ((FirCallableDeclaration)candidate2.getFir()).getReceiverTypeRef();
            ConeKotlinType coneKotlinType = declarationReceiverType = firTypeRef != null ? FirTypeUtilsKt.getConeType(firTypeRef) : null;
            if (declarationReceiverType instanceof ConeClassLikeType) {
                Collection<ConeStarProjection> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ConeTypeProjection[] coneTypeProjectionArray = ((ConeClassLikeType)declarationReceiverType).getTypeArguments();
                ConeClassLikeLookupTag coneClassLikeLookupTag = ((ConeClassLikeType)declarationReceiverType).getLookupTag();
                KotlinTypeMarker kotlinTypeMarker = extensionReceiverType;
                TypeCheckerProviderContext typeCheckerProviderContext = TypeComponentsKt.getTypeContext(this.getSession());
                AbstractTypeChecker abstractTypeChecker = AbstractTypeChecker.INSTANCE;
                boolean $i$f$map = false;
                void var6_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void item$iv$iv;
                    void var12_16 = item$iv$iv = $this$mapTo$iv$iv[i];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(ConeStarProjection.INSTANCE);
                }
                collection = (List)destination$iv$iv;
                Collection $this$toTypedArray$iv = collection;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                ConeStarProjection[] coneStarProjectionArray = thisCollection$iv.toArray(new ConeStarProjection[0]);
                if (coneStarProjectionArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                if (!AbstractTypeChecker.isSubtypeOf$default(abstractTypeChecker, typeCheckerProviderContext, kotlinTypeMarker, (KotlinTypeMarker)TypeConstructionUtilsKt.constructClassType$default(coneClassLikeLookupTag, coneStarProjectionArray, true, null, 4, null), false, 8, null)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final <T extends FirBasedSymbol<?>> void consumeCallableCandidate(FirCallableSymbol<?> candidate2, TowerScopeLevel.TowerScopeLevelProcessor<? super T> processor2) {
        boolean receiverExpected;
        FirTypeRef candidateReceiverTypeRef = ((FirCallableDeclaration)candidate2.getFir()).getReceiverTypeRef();
        if (candidateReceiverTypeRef == null == (receiverExpected = this.extensionsOnly || this.extensionReceiver != null)) {
            return;
        }
        ReceiverValue dispatchReceiverValue2 = this.dispatchReceiverValue(candidate2);
        if (dispatchReceiverValue2 == null && this.shouldSkipCandidateWithInconsistentExtensionReceiver(candidate2)) {
            return;
        }
        Object object = FirObjectImportedCallableScopeKt.getImportedFromObjectData((FirCallableDeclaration)candidate2.getFir());
        if (object == null || (object = ((ImportedFromObjectData)object).getOriginal()) == null || (object = ((FirCallableDeclaration)object).getSymbol()) == null) {
            object = candidate2;
        }
        FirCallableSymbol<?> unwrappedCandidate = object;
        TowerScopeLevel.TowerScopeLevelProcessor.DefaultImpls.consumeCandidate$default(processor2, unwrappedCandidate, dispatchReceiverValue2, this.extensionReceiver, this.scope, null, false, 48, null);
    }

    @Override
    @NotNull
    public ProcessResult processFunctionsByName(@NotNull CallInfo info, @NotNull TowerScopeLevel.TowerScopeLevelProcessor<? super FirFunctionSymbol<?>> processor2) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Ref.BooleanRef empty2 = new Ref.BooleanRef();
        empty2.element = true;
        FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
        if (firLookupTrackerComponent != null) {
            FirLookupTrackerComponentKt.recordCallLookup(firLookupTrackerComponent, (AbstractCallInfo)info, this.scope.getScopeOwnerLookupNames());
        }
        ConstructorProcessingKt.processFunctionsAndConstructorsByName(this.scope, info.getName(), this.getSession(), this.bodyResolveComponents, this.includeInnerConstructors, (Function1)new Function1<FirCallableSymbol<?>, Unit>(empty2, this, processor2){
            final /* synthetic */ Ref.BooleanRef $empty;
            final /* synthetic */ ScopeTowerLevel this$0;
            final /* synthetic */ TowerScopeLevel.TowerScopeLevelProcessor<FirFunctionSymbol<?>> $processor;
            {
                this.$empty = $empty;
                this.this$0 = $receiver;
                this.$processor = $processor;
                super(1);
            }

            public final void invoke(@NotNull FirCallableSymbol<?> candidate2) {
                Intrinsics.checkNotNullParameter(candidate2, (String)"candidate");
                this.$empty.element = false;
                ScopeTowerLevel.access$consumeCallableCandidate(this.this$0, candidate2, this.$processor);
            }
        });
        return empty2.element ? ProcessResult.SCOPE_EMPTY : ProcessResult.FOUND;
    }

    @Override
    @NotNull
    public ProcessResult processPropertiesByName(@NotNull CallInfo info, @NotNull TowerScopeLevel.TowerScopeLevelProcessor<? super FirVariableSymbol<?>> processor2) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Ref.BooleanRef empty2 = new Ref.BooleanRef();
        empty2.element = true;
        FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
        if (firLookupTrackerComponent != null) {
            FirLookupTrackerComponentKt.recordCallLookup(firLookupTrackerComponent, (AbstractCallInfo)info, this.scope.getScopeOwnerLookupNames());
        }
        this.scope.processPropertiesByName(info.getName(), (Function1)new Function1<FirVariableSymbol<?>, Unit>(empty2, this, processor2){
            final /* synthetic */ Ref.BooleanRef $empty;
            final /* synthetic */ ScopeTowerLevel this$0;
            final /* synthetic */ TowerScopeLevel.TowerScopeLevelProcessor<FirVariableSymbol<?>> $processor;
            {
                this.$empty = $empty;
                this.this$0 = $receiver;
                this.$processor = $processor;
                super(1);
            }

            public final void invoke(@NotNull FirVariableSymbol<?> candidate2) {
                Intrinsics.checkNotNullParameter(candidate2, (String)"candidate");
                this.$empty.element = false;
                ScopeTowerLevel.access$consumeCallableCandidate(this.this$0, candidate2, this.$processor);
            }
        });
        return empty2.element ? ProcessResult.SCOPE_EMPTY : ProcessResult.FOUND;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ProcessResult processObjectsByName(@NotNull CallInfo info, @NotNull TowerScopeLevel.TowerScopeLevelProcessor<? super FirBasedSymbol<?>> processor2) {
        void name$iv;
        void $this$processClassifiersByName$iv;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Ref.BooleanRef empty2 = new Ref.BooleanRef();
        empty2.element = true;
        FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
        if (firLookupTrackerComponent != null) {
            FirLookupTrackerComponentKt.recordCallLookup(firLookupTrackerComponent, (AbstractCallInfo)info, this.scope.getScopeOwnerLookupNames());
        }
        FirScope firScope = this.scope;
        Name name = info.getName();
        Function1 processor$iv = new Function1<FirClassifierSymbol<?>, Unit>(empty2, processor2, this){
            final /* synthetic */ Ref.BooleanRef $empty;
            final /* synthetic */ TowerScopeLevel.TowerScopeLevelProcessor<FirBasedSymbol<?>> $processor;
            final /* synthetic */ ScopeTowerLevel this$0;
            {
                this.$empty = $empty;
                this.$processor = $processor;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull FirClassifierSymbol<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$empty.element = false;
                TowerScopeLevel.TowerScopeLevelProcessor.DefaultImpls.consumeCandidate$default(this.$processor, it, null, null, this.this$0.getScope(), null, true, 16, null);
            }
        };
        boolean $i$f$processClassifiersByName = false;
        $this$processClassifiersByName$iv.processClassifiersByNameWithSubstitution((Name)name$iv, (Function2)new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(processor$iv){
            final /* synthetic */ Function1 $processor;
            {
                this.$processor = $processor;
                super(2);
            }

            public final void invoke(@NotNull FirClassifierSymbol<?> symbol2, @NotNull ConeSubstitutor coneSubstitutor) {
                Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
                Intrinsics.checkNotNullParameter((Object)coneSubstitutor, (String)"<anonymous parameter 1>");
                this.$processor.invoke(symbol2);
            }
        });
        return empty2.element ? ProcessResult.SCOPE_EMPTY : ProcessResult.FOUND;
    }

    public static final /* synthetic */ void access$consumeCallableCandidate(ScopeTowerLevel $this, FirCallableSymbol candidate2, TowerScopeLevel.TowerScopeLevelProcessor processor2) {
        $this.consumeCallableCandidate(candidate2, processor2);
    }
}

