/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.CompoundInstruction;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/AssertIntrinsic;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getListOfAcceptableFunctions", "", "", "unwind", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "ir.interpreter"})
public final class AssertIntrinsic
extends IntrinsicBase {
    @NotNull
    public static final AssertIntrinsic INSTANCE = new AssertIntrinsic();

    private AssertIntrinsic() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        return CollectionsKt.listOf((Object)"kotlin.PreconditionsKt.assert");
    }

    @Override
    @NotNull
    public List<Instruction> unwind(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (irFunction2.getValueParameters().size() == 1) {
            return CollectionsKt.listOf((Object)this.customEvaluateInstruction(irFunction2, environment));
        }
        IrValueParameter lambdaParameter = (IrValueParameter)CollectionsKt.last(irFunction2.getValueParameters());
        KFunctionState lambdaState = (KFunctionState)environment.getCallStack$ir_interpreter().loadState(lambdaParameter.getSymbol());
        IrCall call2 = IrTreeBuildUtilsKt.createCall$default((IrSimpleFunction)lambdaState.getInvokeSymbol().getOwner(), null, 1, null);
        call2.setDispatchReceiver(IrTreeBuildUtilsKt.createGetValue(lambdaParameter));
        Object[] objectArray = new Instruction[]{this.customEvaluateInstruction(irFunction2, environment), new CompoundInstruction(call2)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void evaluate(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        boolean value2 = StateKt.asBoolean(environment.getCallStack$ir_interpreter().loadState(((IrValueParameter)CollectionsKt.first(irFunction2.getValueParameters())).getSymbol()));
        if (value2) {
            return;
        }
        switch (irFunction2.getValueParameters().size()) {
            case 1: {
                ExceptionUtilsKt.handleUserException((Throwable)((Object)new AssertionError((Object)"Assertion failed")), environment);
                break;
            }
            case 2: {
                ExceptionUtilsKt.handleUserException((Throwable)((Object)new AssertionError((Object)StateKt.asString(environment.getCallStack$ir_interpreter().popState()))), environment);
            }
        }
    }
}

