/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.ClassTemplate;
import org.junit.jupiter.api.extension.ClassTemplateInvocationContext;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.ClassTemplateInvocationTestDescriptor;
import org.junit.jupiter.engine.descriptor.ClassTemplateTestDescriptor;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.Filterable;
import org.junit.jupiter.engine.descriptor.NestedClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestClassAware;
import org.junit.jupiter.engine.discovery.predicates.IsNestedTestClass;
import org.junit.jupiter.engine.discovery.predicates.IsTestClassWithTests;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.IterationSelector;
import org.junit.platform.engine.discovery.NestedClassSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.discovery.SelectorResolver;

class ClassSelectorResolver
implements SelectorResolver {
    private static final IsTestClassWithTests isTestClassWithTests = new IsTestClassWithTests();
    private static final IsNestedTestClass isNestedTestClass = new IsNestedTestClass();
    private static final Predicate<Class<?>> isAnnotatedWithClassTemplate = testClass -> AnnotationSupport.isAnnotated((AnnotatedElement)testClass, ClassTemplate.class);
    private final Predicate<String> classNameFilter;
    private final JupiterConfiguration configuration;

    ClassSelectorResolver(Predicate<String> classNameFilter, JupiterConfiguration configuration) {
        this.classNameFilter = classNameFilter;
        this.configuration = configuration;
    }

    public SelectorResolver.Resolution resolve(ClassSelector selector, SelectorResolver.Context context) {
        Class testClass = selector.getJavaClass();
        if (isTestClassWithTests.test(testClass)) {
            if (this.classNameFilter.test(testClass.getName())) {
                return this.toResolution(context.addToParent(parent -> Optional.of(this.newStaticClassTestDescriptor((TestDescriptor)parent, testClass))));
            }
        } else if (isNestedTestClass.test(testClass)) {
            return this.toResolution(context.addToParent(() -> DiscoverySelectors.selectClass(testClass.getEnclosingClass()), parent -> Optional.of(this.newMemberClassTestDescriptor((TestDescriptor)parent, testClass))));
        }
        return SelectorResolver.Resolution.unresolved();
    }

    public SelectorResolver.Resolution resolve(NestedClassSelector selector, SelectorResolver.Context context) {
        if (isNestedTestClass.test(selector.getNestedClass())) {
            return this.toResolution(context.addToParent(() -> this.selectClass(selector.getEnclosingClasses()), parent -> Optional.of(this.newMemberClassTestDescriptor((TestDescriptor)parent, selector.getNestedClass()))));
        }
        return SelectorResolver.Resolution.unresolved();
    }

    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId uniqueId = selector.getUniqueId();
        UniqueId.Segment lastSegment = uniqueId.getLastSegment();
        if ("class".equals(lastSegment.getType())) {
            return this.resolveStaticClassUniqueId(context, lastSegment, __ -> true, this::newClassTestDescriptor);
        }
        if ("class-template".equals(lastSegment.getType())) {
            return this.resolveStaticClassUniqueId(context, lastSegment, isAnnotatedWithClassTemplate, this::newStaticClassTemplateTestDescriptor);
        }
        if ("nested-class".equals(lastSegment.getType())) {
            return this.resolveNestedClassUniqueId(context, uniqueId, __ -> true, this::newNestedClassTestDescriptor);
        }
        if ("nested-class-template".equals(lastSegment.getType())) {
            return this.resolveNestedClassUniqueId(context, uniqueId, isAnnotatedWithClassTemplate, this::newNestedClassTemplateTestDescriptor);
        }
        if ("class-template-invocation".equals(lastSegment.getType())) {
            Optional testDescriptor = context.addToParent(() -> DiscoverySelectors.selectUniqueId((UniqueId)uniqueId.removeLastSegment()), parent -> {
                int index = Integer.parseInt(lastSegment.getValue().substring(1));
                return Optional.of(this.newDummyClassTemplateInvocationTestDescriptor((TestDescriptor)parent, index));
            });
            return this.toInvocationMatch(testDescriptor).map(SelectorResolver.Resolution::match).orElse(SelectorResolver.Resolution.unresolved());
        }
        return SelectorResolver.Resolution.unresolved();
    }

    public SelectorResolver.Resolution resolve(IterationSelector selector, SelectorResolver.Context context) {
        DiscoverySelector parentSelector = selector.getParentSelector();
        if (parentSelector instanceof ClassSelector && isAnnotatedWithClassTemplate.test(((ClassSelector)parentSelector).getJavaClass())) {
            return this.resolveIterations(selector, context);
        }
        if (parentSelector instanceof NestedClassSelector && isAnnotatedWithClassTemplate.test(((NestedClassSelector)parentSelector).getNestedClass())) {
            return this.resolveIterations(selector, context);
        }
        return SelectorResolver.Resolution.unresolved();
    }

    private SelectorResolver.Resolution resolveIterations(IterationSelector selector, SelectorResolver.Context context) {
        DiscoverySelector parentSelector = selector.getParentSelector();
        Set matches = selector.getIterationIndices().stream().map(index -> context.addToParent(() -> parentSelector, parent -> Optional.of(this.newDummyClassTemplateInvocationTestDescriptor((TestDescriptor)parent, index + 1)))).map(this::toInvocationMatch).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        return matches.isEmpty() ? SelectorResolver.Resolution.unresolved() : SelectorResolver.Resolution.matches(matches);
    }

    private SelectorResolver.Resolution resolveStaticClassUniqueId(SelectorResolver.Context context, UniqueId.Segment lastSegment, Predicate<? super Class<?>> condition, BiFunction<TestDescriptor, Class<?>, ClassBasedTestDescriptor> factory) {
        String className = lastSegment.getValue();
        return ReflectionSupport.tryToLoadClass((String)className).toOptional().filter(isTestClassWithTests).filter(condition).map(testClass -> this.toResolution(context.addToParent(parent -> Optional.of((ClassBasedTestDescriptor)factory.apply((TestDescriptor)parent, (Class<?>)testClass))))).orElse(SelectorResolver.Resolution.unresolved());
    }

    private SelectorResolver.Resolution resolveNestedClassUniqueId(SelectorResolver.Context context, UniqueId uniqueId, Predicate<? super Class<?>> condition, BiFunction<TestDescriptor, Class<?>, ClassBasedTestDescriptor> factory) {
        String simpleClassName = uniqueId.getLastSegment().getValue();
        return this.toResolution(context.addToParent(() -> DiscoverySelectors.selectUniqueId((UniqueId)uniqueId.removeLastSegment()), parent -> {
            Class<?> parentTestClass = ((TestClassAware)parent).getTestClass();
            return ReflectionSupport.findNestedClasses(parentTestClass, isNestedTestClass.and(FunctionUtils.where(Class::getSimpleName, Predicate.isEqual(simpleClassName)))).stream().findFirst().filter(condition).map(testClass -> (ClassBasedTestDescriptor)factory.apply((TestDescriptor)parent, (Class<?>)testClass));
        }));
    }

    private ClassTemplateInvocationTestDescriptor newDummyClassTemplateInvocationTestDescriptor(TestDescriptor parent, int index) {
        UniqueId uniqueId = parent.getUniqueId().append("class-template-invocation", "#" + index);
        return new ClassTemplateInvocationTestDescriptor(uniqueId, (ClassTemplateTestDescriptor)parent, DummyClassTemplateInvocationContext.INSTANCE, index, parent.getSource().orElse(null), this.configuration);
    }

    private ClassBasedTestDescriptor newStaticClassTestDescriptor(TestDescriptor parent, Class<?> testClass) {
        return isAnnotatedWithClassTemplate.test(testClass) ? this.newStaticClassTemplateTestDescriptor(parent, testClass) : this.newClassTestDescriptor(parent, testClass);
    }

    private ClassTemplateTestDescriptor newStaticClassTemplateTestDescriptor(TestDescriptor parent, Class<?> testClass) {
        return this.newClassTemplateTestDescriptor(parent, "class-template", this.newClassTestDescriptor(parent, testClass));
    }

    private ClassTestDescriptor newClassTestDescriptor(TestDescriptor parent, Class<?> testClass) {
        return new ClassTestDescriptor(parent.getUniqueId().append("class", testClass.getName()), testClass, this.configuration);
    }

    private ClassBasedTestDescriptor newMemberClassTestDescriptor(TestDescriptor parent, Class<?> testClass) {
        return isAnnotatedWithClassTemplate.test(testClass) ? this.newNestedClassTemplateTestDescriptor(parent, testClass) : this.newNestedClassTestDescriptor(parent, testClass);
    }

    private ClassTemplateTestDescriptor newNestedClassTemplateTestDescriptor(TestDescriptor parent, Class<?> testClass) {
        return this.newClassTemplateTestDescriptor(parent, "nested-class-template", this.newNestedClassTestDescriptor(parent, testClass));
    }

    private NestedClassTestDescriptor newNestedClassTestDescriptor(TestDescriptor parent, Class<?> testClass) {
        UniqueId uniqueId = parent.getUniqueId().append("nested-class", testClass.getSimpleName());
        return new NestedClassTestDescriptor(uniqueId, testClass, () -> NestedClassTestDescriptor.getEnclosingTestClasses(parent), this.configuration);
    }

    private ClassTemplateTestDescriptor newClassTemplateTestDescriptor(TestDescriptor parent, String segmentType, ClassBasedTestDescriptor delegate) {
        delegate.setParent(parent);
        String segmentValue = delegate.getUniqueId().getLastSegment().getValue();
        UniqueId uniqueId = parent.getUniqueId().append(segmentType, segmentValue);
        return new ClassTemplateTestDescriptor(uniqueId, delegate);
    }

    private Optional<SelectorResolver.Match> toInvocationMatch(Optional<ClassTemplateInvocationTestDescriptor> testDescriptor) {
        return testDescriptor.map(it -> SelectorResolver.Match.exact((TestDescriptor)it, this.expansionCallback((TestDescriptor)it, () -> it.getParent().map(parent -> ClassSelectorResolver.getTestClasses((TestClassAware)parent)).orElse(Collections.emptyList()))));
    }

    private SelectorResolver.Resolution toResolution(Optional<? extends ClassBasedTestDescriptor> testDescriptor) {
        return testDescriptor.map(it -> SelectorResolver.Resolution.match((SelectorResolver.Match)SelectorResolver.Match.exact((TestDescriptor)it, this.expansionCallback((ClassBasedTestDescriptor)it)))).orElse(SelectorResolver.Resolution.unresolved());
    }

    private Supplier<Set<? extends DiscoverySelector>> expansionCallback(ClassBasedTestDescriptor testDescriptor) {
        return this.expansionCallback(testDescriptor, () -> ClassSelectorResolver.getTestClasses(testDescriptor));
    }

    private static List<Class<?>> getTestClasses(TestClassAware testDescriptor) {
        ArrayList testClasses = new ArrayList(testDescriptor.getEnclosingTestClasses());
        testClasses.add(testDescriptor.getTestClass());
        return testClasses;
    }

    private Supplier<Set<? extends DiscoverySelector>> expansionCallback(TestDescriptor testDescriptor, Supplier<List<Class<?>>> testClassesSupplier) {
        return () -> {
            if (testDescriptor instanceof Filterable) {
                Filterable filterable = (Filterable)testDescriptor;
                filterable.getDynamicDescendantFilter().allowAll();
            }
            List testClasses = (List)testClassesSupplier.get();
            Class testClass = (Class)testClasses.get(testClasses.size() - 1);
            Stream<DiscoverySelector> methods = ReflectionSupport.findMethods((Class)testClass, IsTestClassWithTests.isTestOrTestFactoryOrTestTemplateMethod, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).stream().map(method -> this.selectMethod(testClasses, (Method)method));
            Stream<NestedClassSelector> nestedClasses = ReflectionSupport.streamNestedClasses((Class)testClass, (Predicate)isNestedTestClass).map(nestedClass -> DiscoverySelectors.selectNestedClass((List)testClasses, (Class)nestedClass));
            return Stream.concat(methods, nestedClasses).collect(Collectors.toCollection(LinkedHashSet::new));
        };
    }

    private DiscoverySelector selectClass(List<Class<?>> classes) {
        if (classes.size() == 1) {
            return DiscoverySelectors.selectClass(classes.get(0));
        }
        int lastIndex = classes.size() - 1;
        return DiscoverySelectors.selectNestedClass(classes.subList(0, lastIndex), classes.get(lastIndex));
    }

    private DiscoverySelector selectMethod(List<Class<?>> classes, Method method) {
        if (classes.size() == 1) {
            return DiscoverySelectors.selectMethod(classes.get(0), (Method)method);
        }
        int lastIndex = classes.size() - 1;
        return DiscoverySelectors.selectNestedMethod(classes.subList(0, lastIndex), classes.get(lastIndex), (Method)method);
    }

    static class DummyClassTemplateInvocationContext
    implements ClassTemplateInvocationContext {
        private static final DummyClassTemplateInvocationContext INSTANCE = new DummyClassTemplateInvocationContext();

        DummyClassTemplateInvocationContext() {
        }
    }
}

