/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region.service;

import java.io.IOException;
import org.lionsoul.ip2region.service.ConfigBuilder;
import org.lionsoul.ip2region.service.InvalidCachePolicyException;
import org.lionsoul.ip2region.xdb.Header;
import org.lionsoul.ip2region.xdb.LongByteArray;
import org.lionsoul.ip2region.xdb.Version;
import org.lionsoul.ip2region.xdb.XdbException;

public class Config {
    public static final int NoCache = 0;
    public static final int VIndexCache = 1;
    public static final int BufferCache = 2;
    public final int cachePolicy;
    public final Version ipVersion;
    public final String xdbPath;
    public final Header header;
    public final byte[] vIndex;
    public final LongByteArray cBuffer;
    public final int searchers;

    public static ConfigBuilder custom() {
        return new ConfigBuilder();
    }

    protected Config(int cachePolicy, Version ipVersion, String xdbPath, Header header, byte[] vIndex, LongByteArray cBuffer, int searchers) throws IOException, XdbException {
        this.cachePolicy = cachePolicy;
        this.ipVersion = ipVersion;
        this.xdbPath = xdbPath;
        this.header = header;
        this.vIndex = vIndex;
        this.cBuffer = cBuffer;
        Version xVersion = Version.fromHeader(header);
        if (header.ipVersion != ipVersion.id) {
            throw new XdbException("ip verison not match: xdb file " + xdbPath + " (" + xVersion.name + "), as " + ipVersion.name + " expected");
        }
        this.searchers = searchers;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        sb.append("cache_policy:").append(this.cachePolicy).append(',');
        sb.append("version:").append(this.ipVersion.toString()).append(',');
        sb.append("xdb_path:").append(this.xdbPath).append(',');
        sb.append("header:").append(this.header.toString()).append(',');
        if (this.vIndex == null) {
            sb.append("v_index: null, ");
        } else {
            sb.append("v_index: {bytes: ").append(this.vIndex.length).append("},");
        }
        if (this.cBuffer == null) {
            sb.append("c_buffer: null, ");
        } else {
            sb.append("c_buffer: {bytes: ").append(this.cBuffer.length()).append("},");
        }
        sb.append("searchers:").append(this.searchers);
        sb.append('}');
        return sb.toString();
    }

    public static final int cachePolicyFromName(String name) throws InvalidCachePolicyException {
        String lName = name.toLowerCase();
        if (lName.equals("file") || lName.equals("nocache")) {
            return 0;
        }
        if (lName.equals("vectorindex") || lName.equals("vindex") || lName.equals("vindexcache")) {
            return 1;
        }
        if (lName.equals("content") || lName.equals("buffercache")) {
            return 2;
        }
        throw new InvalidCachePolicyException("invalid cache policy `" + name + "`");
    }
}

