/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region.service;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.lionsoul.ip2region.service.Config;
import org.lionsoul.ip2region.xdb.Header;
import org.lionsoul.ip2region.xdb.LongByteArray;
import org.lionsoul.ip2region.xdb.Searcher;
import org.lionsoul.ip2region.xdb.Version;
import org.lionsoul.ip2region.xdb.XdbException;

public class ConfigBuilder {
    private int cachePolicy = 1;
    private String xdbPath = null;
    private int searchers = 20;

    public ConfigBuilder() {
    }

    public ConfigBuilder(String xdbPath) {
        this.xdbPath = xdbPath;
    }

    public ConfigBuilder setCachePolicy(int cachePolicy) {
        this.cachePolicy = cachePolicy;
        return this;
    }

    public ConfigBuilder setXdbPath(String xdbPath) {
        this.xdbPath = xdbPath;
        return this;
    }

    public ConfigBuilder setSearchers(int searchers) {
        this.searchers = searchers;
        return this;
    }

    private Config build(Version ipVersion) throws IOException, XdbException {
        RandomAccessFile raf = new RandomAccessFile(this.xdbPath, "r");
        Searcher.verify(raf);
        Header header = Searcher.loadHeader(raf);
        byte[] vIndex = this.cachePolicy == 1 ? Searcher.loadVectorIndex(raf) : null;
        LongByteArray cBuffer = this.cachePolicy == 2 ? Searcher.loadContent(raf) : null;
        raf.close();
        return new Config(this.cachePolicy, ipVersion, this.xdbPath, header, vIndex, cBuffer, this.searchers);
    }

    public Config asV4() throws IOException, XdbException {
        return this.build(Version.IPv4);
    }

    public Config asV6() throws IOException, XdbException {
        return this.build(Version.IPv6);
    }
}

