/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region.xdb;

public class LittleEndian {
    public static final int[] shiftIndex = new int[]{0, 8, 16, 24, 32, 40, 48, 56};

    public static void put(byte[] buff, int offset, long value, int bytes) {
        if (bytes > 8) {
            throw new IndexOutOfBoundsException("bytes should be <= 8");
        }
        for (int i = 0; i < bytes; ++i) {
            buff[offset++] = (byte)(value >>> shiftIndex[i] & 0xFFL);
        }
    }

    public static void putUint32(byte[] buff, int offset, long value) {
        buff[offset++] = (byte)(value & 0xFFL);
        buff[offset++] = (byte)(value >> 8 & 0xFFL);
        buff[offset++] = (byte)(value >> 16 & 0xFFL);
        buff[offset] = (byte)(value >> 24 & 0xFFL);
    }

    public static void putUint16(byte[] buff, int offset, int value) {
        buff[offset++] = (byte)(value & 0xFF);
        buff[offset] = (byte)(value >> 8 & 0xFF);
    }

    public static long getUint32(byte[] buff, int offset) {
        return (long)buff[offset++] & 0xFFL | (long)(buff[offset++] << 8) & 0xFF00L | (long)(buff[offset++] << 16) & 0xFF0000L | (long)(buff[offset] << 24) & 0xFF000000L;
    }

    public static int getUint16(byte[] buff, int offset) {
        return buff[offset++] & 0xFF | buff[offset] << 8 & 0xFF00;
    }
}

