/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.IOUtils;

public class ZipUtil {
    private static String charset = "UTF-8";

    @Deprecated
    public static void setMaxSize(long size) {
    }

    public static void setDefaultCharset(String charset) {
        ZipUtil.charset = charset;
    }

    public static void unZipFiles(String zipPath, String descDir) throws IOException {
        ZipUtil.unZipFiles(new File(zipPath), descDir);
    }

    public static void unZipFiles(InputStream src, String descDir) throws IOException {
        ZipUtil.unZipFileByApacheCommonCompress(src, descDir);
    }

    public static void unZipFiles(File zipFile, String descDir) throws IOException {
        ZipUtil.unZipFileByApacheCommonCompress(zipFile, descDir);
    }

    public static void unZipFileByApacheCommonCompress(File srcFile, String descDir) throws IOException {
        if (srcFile == null || !srcFile.exists()) {
            throw new IOException("\u89e3\u538b\u6587\u4ef6\u4e0d\u5b58\u5728: " + srcFile);
        }
        try (FileInputStream fin = new FileInputStream(srcFile);){
            ZipUtil.unZipFileByApacheCommonCompress(fin, descDir);
        }
    }

    public static void unZipFileByApacheCommonCompress(InputStream src, String descDir) throws IOException {
        Path pathFile = Files.createDirectories(Paths.get(descDir, new String[0]), new FileAttribute[0]);
        try (ZipArchiveInputStream zipFile = new ZipArchiveInputStream(src, charset, false, true);){
            ZipArchiveEntry entry = null;
            while ((entry = zipFile.getNextEntry()) != null) {
                Path f = null;
                try {
                    f = pathFile.resolve(entry.getName());
                }
                catch (InvalidPathException e) {
                    f = pathFile.resolve(new String(entry.getRawName(), "GBK"));
                }
                if (f == null || !f.startsWith(pathFile)) {
                    throw new IOException(String.format("\u4e0d\u5408\u6cd5\u7684\u8def\u5f84\uff1a%s", f));
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(f, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(f.getParent(), new FileAttribute[0]);
                OutputStream o = Files.newOutputStream(f, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    IOUtils.copy((InputStream)zipFile, (OutputStream)o);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (o == null) continue;
                    if (throwable != null) {
                        try {
                            o.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    o.close();
                }
            }
        }
    }
}

