/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.config;

import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springblade.core.tool.support.xss.XssFilter;
import org.springblade.core.tool.support.xss.XssProperties;
import org.springblade.core.tool.support.xss.XssUrlProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"blade.xss.enable"}, havingValue="true")
@EnableConfigurationProperties(value={XssProperties.class, XssUrlProperties.class})
public class XssConfiguration {
    private final XssProperties xssProperties;
    private final XssUrlProperties xssUrlProperties;

    @Bean
    public FilterRegistrationBean<XssFilter> xssFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        registration.setFilter((Filter)new XssFilter(this.xssProperties, this.xssUrlProperties));
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("xssFilter");
        registration.setOrder(Integer.MAX_VALUE);
        return registration;
    }

    public XssConfiguration(XssProperties xssProperties, XssUrlProperties xssUrlProperties) {
        this.xssProperties = xssProperties;
        this.xssUrlProperties = xssUrlProperties;
    }
}

