/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.node;

import java.util.ArrayList;
import java.util.List;
import org.springblade.core.tool.node.INode;

public class ForestNodeManager<T extends INode> {
    private List<T> list;
    private List<Integer> parentIds = new ArrayList<Integer>();

    public ForestNodeManager(List<T> items) {
        this.list = items;
    }

    public INode getTreeNodeAT(int id) {
        for (INode forestNode : this.list) {
            if (forestNode.getId() != id) continue;
            return forestNode;
        }
        return null;
    }

    public void addParentId(Integer parentId) {
        this.parentIds.add(parentId);
    }

    public List<T> getRoot() {
        ArrayList<INode> roots = new ArrayList<INode>();
        for (INode forestNode : this.list) {
            if (forestNode.getParentId() != 0 && !this.parentIds.contains(forestNode.getId())) continue;
            roots.add(forestNode);
        }
        return roots;
    }
}

