/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.support.xss;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springblade.core.tool.support.xss.XssHttpServletRequestWrapper;
import org.springblade.core.tool.support.xss.XssProperties;
import org.springblade.core.tool.support.xss.XssUrlProperties;

public class XssFilter
implements Filter {
    private XssProperties xssProperties;
    private XssUrlProperties xssUrlProperties;

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path = ((HttpServletRequest)request).getServletPath();
        if (this.isSkip(path)) {
            chain.doFilter(request, response);
        } else {
            XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)xssRequest, response);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSkip(String path) {
        if (this.xssUrlProperties.getExcludePatterns().stream().anyMatch(path::startsWith)) return true;
        if (!this.xssProperties.getSkipUrl().stream().map(url -> url.replace("/**", "")).anyMatch(path::startsWith)) return false;
        return true;
    }

    public void destroy() {
    }

    public XssFilter(XssProperties xssProperties, XssUrlProperties xssUrlProperties) {
        this.xssProperties = xssProperties;
        this.xssUrlProperties = xssUrlProperties;
    }
}

