/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.springblade.core.tool.utils.ObjectUtil;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class CollectionUtil
extends CollectionUtils {
    public static <T> boolean contains(@Nullable T[] array, T element) {
        if (array == null) {
            return false;
        }
        return Arrays.stream(array).anyMatch(x -> ObjectUtil.nullSafeEquals((Object)x, (Object)element));
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static boolean isNotEmpty(@Nullable Collection<?> coll) {
        return !CollectionUtils.isEmpty(coll);
    }

    public static boolean isNotEmpty(@Nullable Map<?, ?> map) {
        return !CollectionUtils.isEmpty(map);
    }
}

