/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.util.Assert;

class MainMethod {
    private final Method method;

    MainMethod() {
        this(Thread.currentThread());
    }

    MainMethod(Thread thread) {
        Assert.notNull((Object)thread, (String)"'thread' must not be null");
        this.method = this.getMainMethod(thread);
    }

    private Method getMainMethod(Thread thread) {
        StackTraceElement[] stackTrace = thread.getStackTrace();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            Method method;
            StackTraceElement element = stackTrace[i];
            if (!"main".equals(element.getMethodName()) || this.isLoaderClass(element.getClassName()) || (method = this.getMainMethod(element)) == null) continue;
            return method;
        }
        throw new IllegalStateException("Unable to find main method");
    }

    private boolean isLoaderClass(String className) {
        return className.startsWith("org.springframework.boot.loader.");
    }

    private Method getMainMethod(StackTraceElement element) {
        try {
            Class<?> elementClass = Class.forName(element.getClassName());
            Method method = MainMethod.getMainMethod(elementClass);
            if (Modifier.isStatic(method.getModifiers())) {
                return method;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Method getMainMethod(Class<?> clazz) throws Exception {
        try {
            return clazz.getDeclaredMethod("main", String[].class);
        }
        catch (NoSuchMethodException ex) {
            return clazz.getDeclaredMethod("main", new Class[0]);
        }
    }

    Method getMethod() {
        return this.method;
    }

    String getDeclaringClassName() {
        return this.method.getDeclaringClass().getName();
    }
}

