/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.KeyValue;
import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.SortArgs;
import com.lambdaworks.redis.ZStoreArgs;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.ByteArrayOutput;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandOutput;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.pubsub.RedisPubSubConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.netty.channel.ChannelException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.lettuce.LettuceSubscription;
import org.springframework.data.redis.connection.lettuce.LettuceUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LettuceConnection
implements RedisConnection {
    private final RedisAsyncConnection<byte[], byte[]> asyncConn;
    private final com.lambdaworks.redis.RedisConnection<byte[], byte[]> con;
    private final RedisCodec<byte[], byte[]> codec = LettuceUtils.CODEC;
    private final long timeout;
    private boolean isClosed = false;
    private boolean isMulti = false;
    private boolean isPipelined = false;
    private List<Command<?, ?, ?>> ppline;
    private RedisClient client;
    private volatile LettuceSubscription subscription;

    public LettuceConnection(RedisAsyncConnection<byte[], byte[]> connection, long timeout, RedisClient client) {
        Assert.notNull(connection, (String)"a valid connection is required");
        this.asyncConn = connection;
        this.timeout = timeout;
        this.con = new com.lambdaworks.redis.RedisConnection(this.asyncConn);
        this.client = client;
    }

    protected DataAccessException convertLettuceAccessException(Exception ex) {
        if (ex instanceof RedisException) {
            return LettuceUtils.convertRedisAccessException((RuntimeException)((RedisException)ex));
        }
        if (ex instanceof ChannelException) {
            return new RedisConnectionFailureException("Redis connection failed", ex);
        }
        if (ex instanceof TimeoutException) {
            return new QueryTimeoutException("Redis command timed out", (Throwable)ex);
        }
        return new RedisSystemException("Unknown Lettuce exception", ex);
    }

    private Object await(Command cmd) {
        if (this.isMulti && cmd.type != CommandType.MULTI) {
            return null;
        }
        return this.asyncConn.await(cmd, this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        Assert.hasText((String)command, (String)"a valid command needs to be specified");
        try {
            String name = command.trim().toUpperCase();
            CommandType cmd = CommandType.valueOf((String)name);
            CommandArgs cmdArg = new CommandArgs(this.codec);
            if (!ObjectUtils.isEmpty((Object[])args)) {
                cmdArg.addKeys((Object[])args);
            }
            if (this.isPipelined()) {
                this.pipeline((Future<?>)this.asyncConn.dispatch(cmd, (CommandOutput)new ByteArrayOutput(this.codec), cmdArg));
                return null;
            }
            return this.await(this.asyncConn.dispatch(cmd, (CommandOutput)new ByteArrayOutput(this.codec), cmdArg));
        }
        catch (RedisException ex) {
            throw this.convertLettuceAccessException((Exception)((Object)ex));
        }
    }

    @Override
    public void close() throws DataAccessException {
        this.isClosed = true;
        try {
            this.asyncConn.close();
        }
        catch (RuntimeException ex) {
            throw this.convertLettuceAccessException(ex);
        }
        if (this.subscription != null) {
            this.subscription.doClose();
            this.subscription = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed && !this.isSubscribed();
    }

    public RedisAsyncConnection<byte[], byte[]> getNativeConnection() {
        return this.subscription != null ? this.subscription.pubsub : this.asyncConn;
    }

    @Override
    public boolean isQueueing() {
        return this.isMulti;
    }

    @Override
    public boolean isPipelined() {
        return this.isPipelined;
    }

    @Override
    public void openPipeline() {
        if (!this.isPipelined) {
            this.isPipelined = true;
            this.ppline = new ArrayList();
        }
    }

    @Override
    public List<Object> closePipeline() {
        if (this.isPipelined) {
            this.isPipelined = false;
            boolean done = this.asyncConn.awaitAll((Future[])this.ppline.toArray(new Command[this.ppline.size()]));
            ArrayList<Object> results = new ArrayList<Object>(this.ppline.size());
            InvalidDataAccessApiUsageException problem = null;
            if (done) {
                for (Command<?, ?, ?> cmd : this.ppline) {
                    if (cmd.getOutput().hasError()) {
                        InvalidDataAccessApiUsageException err = new InvalidDataAccessApiUsageException(cmd.getOutput().getError());
                        if (problem == null) {
                            problem = err;
                        }
                        results.add(err);
                        continue;
                    }
                    results.add(cmd.get());
                }
            }
            this.ppline.clear();
            if (problem != null) {
                throw new RedisPipelineException((Exception)problem, (List<Object>)results);
            }
            if (done) {
                return results;
            }
            throw new RedisPipelineException((Exception)new QueryTimeoutException("Redis command timed out"));
        }
        return Collections.emptyList();
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        SortArgs args = LettuceUtils.sort(params);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.sort((Object)key, args));
                return null;
            }
            return this.con.sort((Object)key, args);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] sortKey) {
        SortArgs args = LettuceUtils.sort(params);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.sortStore((Object)key, args, (Object)sortKey));
                return null;
            }
            return this.con.sortStore((Object)key, args, (Object)sortKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long dbSize() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.dbsize());
                return null;
            }
            return this.con.dbsize();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void flushDb() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.flushdb());
                return;
            }
            this.con.flushdb();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void flushAll() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.flushall());
                return;
            }
            this.con.flushall();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void bgSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.bgsave());
                return;
            }
            this.con.bgsave();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void bgWriteAof() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.bgrewriteaof());
                return;
            }
            this.con.bgrewriteaof();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void save() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.save());
                return;
            }
            this.con.save();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<String> getConfig(String param) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.configGet(param));
                return null;
            }
            return this.con.configGet(param);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Properties info() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.info());
                return null;
            }
            return LettuceUtils.info(this.con.info());
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lastSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.lastsave());
                return null;
            }
            return this.con.lastsave().getTime();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setConfig(String param, String value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.configSet(param, value));
                return;
            }
            this.con.configSet(param, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void resetConfigStats() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.configResetstat());
                return;
            }
            this.con.configResetstat();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.isPipelined()) {
                this.asyncConn.shutdown(true);
                return;
            }
            this.con.shutdown(true);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.echo((Object)message));
                return null;
            }
            return (byte[])this.con.echo((Object)message);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public String ping() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.ping());
                return null;
            }
            return this.con.ping();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long del(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.del((Object[])keys));
                return null;
            }
            return this.con.del((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void discard() {
        this.isMulti = false;
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.discard());
                return;
            }
            this.con.discard();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<Object> exec() {
        this.isMulti = false;
        try {
            if (this.isPipelined()) {
                return Collections.singletonList(this.asyncConn.exec());
            }
            return this.con.exec();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean exists(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.exists((Object)key));
                return null;
            }
            return this.con.exists((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.expire((Object)key, seconds));
                return null;
            }
            return this.con.expire((Object)key, seconds);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.expireat((Object)key, unixTime));
                return null;
            }
            return this.con.expireat((Object)key, unixTime);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.keys((Object)pattern));
                return null;
            }
            return new LinkedHashSet<byte[]>(this.con.keys((Object)pattern));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        this.isMulti = true;
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.multi());
                return;
            }
            this.con.multi();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.persist((Object)key));
                return null;
            }
            return this.con.persist((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.move((Object)key, dbIndex));
                return null;
            }
            return this.con.move((Object)key, dbIndex);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] randomKey() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.randomkey());
                return null;
            }
            return (byte[])this.con.randomkey();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.rename((Object)oldName, (Object)newName));
                return;
            }
            this.con.rename((Object)oldName, (Object)newName);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.renamenx((Object)oldName, (Object)newName));
                return null;
            }
            return this.con.renamenx((Object)oldName, (Object)newName);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        try {
            if (this.isPipelined()) {
                throw new UnsupportedOperationException("Lettuce blocks for #select");
            }
            this.con.select(dbIndex);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.ttl((Object)key));
                return null;
            }
            return this.con.ttl((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public DataType type(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.type((Object)key));
                return null;
            }
            return DataType.fromCode(this.con.type((Object)key));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void unwatch() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.unwatch());
                return;
            }
            this.con.unwatch();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void watch(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.watch((Object[])keys));
                return;
            }
            this.con.watch((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.get((Object)key));
                return null;
            }
            return (byte[])this.con.get((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.set((Object)key, (Object)value));
                return;
            }
            this.con.set((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.getset((Object)key, (Object)value));
                return null;
            }
            return (byte[])this.con.getset((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.append((Object)key, (Object)value));
                return null;
            }
            return this.con.append((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.mget((Object[])keys));
                return null;
            }
            return this.con.mget((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.mset(tuples));
                return;
            }
            this.con.mset(tuples);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void mSetNX(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.msetnx(tuples));
                return;
            }
            this.con.msetnx(tuples);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setEx(byte[] key, long time, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.setex((Object)key, time, (Object)value));
                return;
            }
            this.con.setex((Object)key, time, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.setnx((Object)key, (Object)value));
                return null;
            }
            return this.con.setnx((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.getrange((Object)key, start, end));
                return null;
            }
            return (byte[])this.con.getrange((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.decr((Object)key));
                return null;
            }
            return this.con.decr((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.decrby((Object)key, value));
                return null;
            }
            return this.con.decrby((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.incr((Object)key));
                return null;
            }
            return this.con.incr((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.incrby((Object)key, value));
                return null;
            }
            return this.con.incrby((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.getbit((Object)key, offset));
                return null;
            }
            return Long.valueOf(1L).equals(this.con.getbit((Object)key, offset));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setBit(byte[] key, long offset, boolean value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.setbit((Object)key, offset, LettuceUtils.asBit(value)));
            }
            this.con.setbit((Object)key, offset, LettuceUtils.asBit(value));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long start) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.setrange((Object)key, start, (Object)value));
            }
            this.con.setrange((Object)key, start, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long strLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.strlen((Object)key));
                return null;
            }
            return this.con.strlen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.lpush((Object)key, (Object[])new byte[][]{value}));
                return null;
            }
            return this.con.lpush((Object)key, (Object[])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long rPush(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.rpush((Object)key, (Object[])new byte[][]{value}));
                return null;
            }
            return this.con.rpush((Object)key, (Object[])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.blpop((long)timeout, (Object[])keys));
                return null;
            }
            return LettuceUtils.toList((KeyValue<byte[], byte[]>)this.con.blpop((long)timeout, (Object[])keys));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.brpop((long)timeout, (Object[])keys));
                return null;
            }
            return LettuceUtils.toList((KeyValue<byte[], byte[]>)this.con.brpop((long)timeout, (Object[])keys));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.lindex((Object)key, index));
                return null;
            }
            return (byte[])this.con.lindex((Object)key, index);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.linsert((Object)key, LettuceUtils.convertPosition(where), (Object)pivot, (Object)value));
                return null;
            }
            return this.con.linsert((Object)key, LettuceUtils.convertPosition(where), (Object)pivot, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.llen((Object)key));
                return null;
            }
            return this.con.llen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.lpop((Object)key));
                return null;
            }
            return (byte[])this.con.lpop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.lrange((Object)key, start, end));
                return null;
            }
            return this.con.lrange((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.lrem((Object)key, count, (Object)value));
                return null;
            }
            return this.con.lrem((Object)key, count, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.lset((Object)key, index, (Object)value));
                return;
            }
            this.con.lset((Object)key, index, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.ltrim((Object)key, start, end));
                return;
            }
            this.con.ltrim((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.rpop((Object)key));
                return null;
            }
            return (byte[])this.con.rpop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.rpoplpush((Object)srcKey, (Object)dstKey));
                return null;
            }
            return (byte[])this.con.rpoplpush((Object)srcKey, (Object)dstKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.brpoplpush((long)timeout, (Object)srcKey, (Object)dstKey));
                return null;
            }
            return (byte[])this.con.brpoplpush((long)timeout, (Object)srcKey, (Object)dstKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.lpushx((Object)key, (Object)value));
                return null;
            }
            return this.con.lpushx((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.rpushx((Object)key, (Object)value));
                return null;
            }
            return this.con.rpushx((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean sAdd(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.sadd((Object)key, (Object[])new byte[][]{value}));
                return null;
            }
            return this.con.sadd((Object)key, (Object[])new byte[][]{value}) == 1L;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.scard((Object)key));
                return null;
            }
            return this.con.scard((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.sdiff((Object[])keys));
                return null;
            }
            return this.con.sdiff((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.sdiffstore((Object)destKey, (Object[])keys));
                return null;
            }
            return this.con.sdiffstore((Object)destKey, (Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.sinter((Object[])keys));
                return null;
            }
            return this.con.sinter((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.sinterstore((Object)destKey, (Object[])keys));
                return null;
            }
            return this.con.sinterstore((Object)destKey, (Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.sismember((Object)key, (Object)value));
                return null;
            }
            return this.con.sismember((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.smembers((Object)key));
                return null;
            }
            return this.con.smembers((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.smove((Object)srcKey, (Object)destKey, (Object)value));
                return null;
            }
            return this.con.smove((Object)srcKey, (Object)destKey, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.spop((Object)key));
                return null;
            }
            return (byte[])this.con.spop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.srandmember((Object)key));
                return null;
            }
            return (byte[])this.con.srandmember((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean sRem(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.srem((Object)key, (Object[])new byte[][]{value}));
                return null;
            }
            return Long.valueOf(1L).equals(this.con.srem((Object)key, (Object[])new byte[][]{value}));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.sunion((Object[])keys));
                return null;
            }
            return this.con.sunion((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.sunionstore((Object)destKey, (Object[])keys));
                return null;
            }
            return this.con.sunionstore((Object)destKey, (Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zadd((Object)key, score, (Object)value));
                return null;
            }
            return Long.valueOf(1L).equals(this.con.zadd((Object)key, score, (Object)value));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zcard((Object)key));
                return null;
            }
            return this.con.zcard((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        try {
            if (this.isQueueing()) {
                this.pipeline(this.asyncConn.zcount((Object)key, min, max));
                return null;
            }
            return this.con.zcount((Object)key, min, max);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zincrby((Object)key, increment, (Object)value));
                return null;
            }
            return this.con.zincrby((Object)key, increment, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        ZStoreArgs storeArgs = LettuceUtils.zArgs(aggregate, weights);
        try {
            if (this.isQueueing()) {
                this.pipeline(this.asyncConn.zinterstore((Object)destKey, storeArgs, (Object[])sets));
                return null;
            }
            return this.con.zinterstore((Object)destKey, storeArgs, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isQueueing()) {
                this.pipeline(this.asyncConn.zinterstore((Object)destKey, (Object[])sets));
                return null;
            }
            return this.con.zinterstore((Object)destKey, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrange((Object)key, start, end));
                return null;
            }
            return new LinkedHashSet<byte[]>(this.con.zrange((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrangeWithScores((Object)key, start, end));
                return null;
            }
            return LettuceUtils.convertTuple(this.con.zrangeWithScores((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrangebyscore((Object)key, min, max));
                return null;
            }
            return new LinkedHashSet<byte[]>(this.con.zrangebyscore((Object)key, min, max));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrangebyscoreWithScores((Object)key, min, max));
                return null;
            }
            return LettuceUtils.convertTuple(this.con.zrangebyscoreWithScores((Object)key, min, max));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrevrangeWithScores((Object)key, start, end));
                return null;
            }
            return LettuceUtils.convertTuple(this.con.zrevrangeWithScores((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrangebyscore((Object)key, min, max, offset, count));
                return null;
            }
            return new LinkedHashSet<byte[]>(this.con.zrangebyscore((Object)key, min, max, offset, count));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrangebyscoreWithScores((Object)key, min, max, offset, count));
                return null;
            }
            return LettuceUtils.convertTuple(this.con.zrangebyscoreWithScores((Object)key, min, max, offset, count));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrevrangebyscore((Object)key, min, max, offset, count));
                return null;
            }
            return new LinkedHashSet<byte[]>(this.con.zrevrangebyscore((Object)key, min, max, offset, count));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrevrangebyscore((Object)key, min, max));
                return null;
            }
            return new LinkedHashSet<byte[]>(this.con.zrevrangebyscore((Object)key, min, max));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrevrangebyscoreWithScores((Object)key, min, max));
                return null;
            }
            return LettuceUtils.convertTuple(this.con.zrevrangebyscoreWithScores((Object)key, min, max));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrevrangebyscoreWithScores((Object)key, min, max));
                return null;
            }
            return LettuceUtils.convertTuple(this.con.zrevrangebyscoreWithScores((Object)key, min, max));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrank((Object)key, (Object)value));
                return null;
            }
            return this.con.zrank((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean zRem(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrem((Object)key, (Object[])new byte[][]{value}));
                return null;
            }
            return Long.valueOf(1L).equals(this.con.zrem((Object)key, (Object[])new byte[][]{value}));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zremrangebyrank((Object)key, start, end));
                return null;
            }
            return this.con.zremrangebyrank((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zremrangebyscore((Object)key, min, max));
                return null;
            }
            return this.con.zremrangebyscore((Object)key, min, max);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrevrange((Object)key, start, end));
                return null;
            }
            return new LinkedHashSet<byte[]>(this.con.zrevrange((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zrevrank((Object)key, (Object)value));
                return null;
            }
            return this.con.zrevrank((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zscore((Object)key, (Object)value));
                return null;
            }
            return this.con.zscore((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        ZStoreArgs storeArgs = LettuceUtils.zArgs(aggregate, weights);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zunionstore((Object)destKey, storeArgs, (Object[])sets));
                return null;
            }
            return this.con.zunionstore((Object)destKey, storeArgs, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.zunionstore((Object)destKey, (Object[])sets));
                return null;
            }
            return this.con.zunionstore((Object)destKey, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.hset((Object)key, (Object)field, (Object)value));
                return null;
            }
            return this.con.hset((Object)key, (Object)field, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.hsetnx((Object)key, (Object)field, (Object)value));
                return null;
            }
            return this.con.hsetnx((Object)key, (Object)field, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean hDel(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.hdel((Object)key, (Object[])new byte[][]{field}));
                return null;
            }
            return Long.valueOf(1L).equals(this.con.hdel((Object)key, (Object[])new byte[][]{field}));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.hexists((Object)key, (Object)field));
                return null;
            }
            return this.con.hexists((Object)key, (Object)field);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.hget((Object)key, (Object)field));
                return null;
            }
            return (byte[])this.con.hget((Object)key, (Object)field);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.hgetall((Object)key));
                return null;
            }
            return this.con.hgetall((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.hincrby((Object)key, (Object)field, delta));
                return null;
            }
            return this.con.hincrby((Object)key, (Object)field, delta);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.hkeys((Object)key));
                return null;
            }
            return new LinkedHashSet<byte[]>(this.con.hkeys((Object)key));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.hlen((Object)key));
                return null;
            }
            return this.con.hlen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.hmget((Object)key, (Object[])fields));
                return null;
            }
            return this.con.hmget((Object)key, (Object[])fields);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> tuple) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.hmset((Object)key, tuple));
                return;
            }
            this.con.hmset((Object)key, tuple);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.hvals((Object)key));
                return null;
            }
            return this.con.hvals((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.asyncConn.publish((Object)channel, (Object)message));
                return null;
            }
            return this.con.publish((Object)channel, (Object)message);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.checkSubscription();
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            this.subscription = new LettuceSubscription(listener, this.switchToPubSub());
            this.subscription.pSubscribe(patterns);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.checkSubscription();
        try {
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            this.subscription = new LettuceSubscription(listener, this.switchToPubSub());
            this.subscription.subscribe(channels);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private void checkSubscription() {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
    }

    private RedisPubSubConnection<byte[], byte[]> switchToPubSub() {
        this.close();
        return this.client.connectPubSub(LettuceUtils.CODEC);
    }

    private void pipeline(Future<?> command) {
        this.ppline.add((Command)command);
    }
}

