/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.web.deployer.internal.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.osgi.io.OsgiBundleResourcePatternResolver;
import org.springframework.osgi.io.internal.resolver.ImportedBundle;
import org.springframework.osgi.io.internal.resolver.PackageAdminResolver;
import org.springframework.osgi.test.internal.util.jar.JarUtils;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class JasperUtils {
    private static final String TLD_EXT = ".tld";
    private static final String TLD_PATTERN = "*.tld";
    private static final String META_INF = "META-INF";
    static final String JASPER_CLASS = "org.apache.jasper.servlet.JspServlet";
    private static final Log log = LogFactory.getLog(JasperUtils.class);

    private static Resource[] getBundleTagLibs(Bundle bundle) throws IOException {
        OsgiBundleResourcePatternResolver resolver = new OsgiBundleResourcePatternResolver(bundle);
        return resolver.getResources("classpath*:META-INF/**/*.tld");
    }

    private static Resource[] getImportedBundlesTagLibs(BundleContext context, Bundle bundle) {
        PackageAdminResolver resolver = new PackageAdminResolver(context);
        ImportedBundle[] importedBundles = resolver.getImportedBundles(bundle);
        ArrayList<UrlResource> list = new ArrayList<UrlResource>(8);
        for (int i = 0; i < importedBundles.length; ++i) {
            Bundle importedBundle = importedBundles[i].getBundle();
            Enumeration enm = importedBundle.findEntries(META_INF, TLD_PATTERN, true);
            while (enm != null && enm.hasMoreElements()) {
                URL entry = (URL)enm.nextElement();
                list.add(new UrlResource(entry));
            }
        }
        return list.toArray(new Resource[list.size()]);
    }

    private static URL createTaglibJar(Resource[] resources, Manifest mf) throws IOException {
        File tempJar = File.createTempFile("spring.dm.tld.", ".jar");
        tempJar.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tempJar);
        LinkedHashMap<String, Resource> entries = new LinkedHashMap<String, Resource>();
        for (int i = 0; i < resources.length; ++i) {
            Resource resource = resources[i];
            String name = URLDecoder.decode(resource.getURL().getPath(), "UTF8");
            entries.put(name, resource);
        }
        JarUtils.createJar(mf, entries, fos);
        URL jarURL = tempJar.toURL();
        if (log.isTraceEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("\n");
            for (Map.Entry entry : entries.entrySet()) {
                buf.append(entry.getKey());
                buf.append("\t\t");
                buf.append(entry.getValue());
                buf.append("\n");
            }
            log.trace((Object)("Created TLD jar at " + tempJar.toURL() + " containing " + buf));
        }
        return jarURL;
    }

    public static URL[] createTaglibClasspathJars(Bundle bundle) {
        ArrayList<URL> urls = new ArrayList<URL>(2);
        boolean trace = log.isTraceEnabled();
        try {
            BundleContext ctx;
            Object[] importedTLDs;
            Object[] res = JasperUtils.getBundleTagLibs(bundle);
            if (!ObjectUtils.isEmpty((Object[])res)) {
                urls.add(JasperUtils.createTaglibJar((Resource[])res, null));
            }
            if (trace) {
                log.trace((Object)("Bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + " has the following tlds in its classpath " + ObjectUtils.nullSafeToString((Object[])res)));
            }
            if (!ObjectUtils.isEmpty((Object[])(importedTLDs = JasperUtils.getImportedBundlesTagLibs(ctx = OsgiBundleUtils.getBundleContext((Bundle)bundle), bundle)))) {
                urls.add(JasperUtils.createTaglibJar((Resource[])importedTLDs, null));
            }
            if (trace) {
                log.trace((Object)("Bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + " has the following tlds in its imported bundles " + ObjectUtils.nullSafeToString((Object[])importedTLDs)));
            }
            return urls.toArray(new URL[urls.size()]);
        }
        catch (IOException ex) {
            throw (RuntimeException)new IllegalStateException("Cannot create taglib jars").initCause(ex);
        }
    }

    public static URLClassLoader createJasperClassLoader(Bundle bundle, ClassLoader parent) {
        boolean jasperPresent = false;
        try {
            bundle.loadClass(JASPER_CLASS);
            jasperPresent = true;
        }
        catch (ClassNotFoundException cnfe) {
            jasperPresent = ClassUtils.isPresent((String)JASPER_CLASS, (ClassLoader)parent);
        }
        URL[] tldJars = null;
        if (jasperPresent) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Jasper present in bundle " + OsgiStringUtils.nullSafeSymbolicName((Bundle)bundle) + "; looking for taglibs..."));
            }
            tldJars = JasperUtils.createTaglibClasspathJars(bundle);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Jasper not present in bundle " + OsgiStringUtils.nullSafeSymbolicName((Bundle)bundle) + "; ignoring taglibs..."));
            }
            tldJars = new URL[]{};
        }
        return URLClassLoader.newInstance(tldJars, parent);
    }
}

