/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xbean.recipe.AbstractRecipe;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ExecutionContext;
import org.apache.xbean.recipe.MissingAccessorException;
import org.apache.xbean.recipe.MissingFactoryMethodException;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.Recipe;
import org.apache.xbean.recipe.RecipeHelper;
import org.apache.xbean.recipe.ReflectionUtil;
import org.apache.xbean.recipe.UnsetPropertiesRecipe;

public class ObjectRecipe
extends AbstractRecipe {
    private String typeName;
    private Class typeClass;
    private String factoryMethod;
    private List<String> constructorArgNames;
    private List<Class<?>> constructorArgTypes;
    private final LinkedHashMap<Property, Object> properties = new LinkedHashMap();
    private final EnumSet<Option> options = EnumSet.of(Option.FIELD_INJECTION);
    private final Map<String, Object> unsetProperties = new LinkedHashMap<String, Object>();

    public ObjectRecipe(Class typeClass) {
        this(typeClass, null, null, null, null);
    }

    public ObjectRecipe(Class typeClass, String factoryMethod) {
        this(typeClass, factoryMethod, null, null, null);
    }

    public ObjectRecipe(Class typeClass, Map<String, Object> properties) {
        this(typeClass, null, null, null, properties);
    }

    public ObjectRecipe(Class typeClass, String[] constructorArgNames) {
        this(typeClass, null, constructorArgNames, null, null);
    }

    public ObjectRecipe(Class typeClass, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(typeClass, null, constructorArgNames, constructorArgTypes, null);
    }

    public ObjectRecipe(Class type, String factoryMethod, String[] constructorArgNames) {
        this(type, factoryMethod, constructorArgNames, null, null);
    }

    public ObjectRecipe(Class type, String factoryMethod, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(type, factoryMethod, constructorArgNames, constructorArgTypes, null);
    }

    public ObjectRecipe(Class typeClass, String factoryMethod, String[] constructorArgNames, Class[] constructorArgTypes, Map<String, Object> properties) {
        this.typeClass = typeClass;
        this.factoryMethod = factoryMethod;
        this.constructorArgNames = constructorArgNames != null ? Arrays.asList(constructorArgNames) : null;
        List<Class> list = this.constructorArgTypes = constructorArgTypes != null ? Arrays.asList(constructorArgTypes) : null;
        if (properties != null) {
            this.setAllProperties(properties);
        }
    }

    public ObjectRecipe(String typeName) {
        this(typeName, null, null, null, null);
    }

    public ObjectRecipe(String typeName, String factoryMethod) {
        this(typeName, factoryMethod, null, null, null);
    }

    public ObjectRecipe(String typeName, Map<String, Object> properties) {
        this(typeName, null, null, null, properties);
    }

    public ObjectRecipe(String typeName, String[] constructorArgNames) {
        this(typeName, null, constructorArgNames, null, null);
    }

    public ObjectRecipe(String typeName, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(typeName, null, constructorArgNames, constructorArgTypes, null);
    }

    public ObjectRecipe(String typeName, String factoryMethod, String[] constructorArgNames) {
        this(typeName, factoryMethod, constructorArgNames, null, null);
    }

    public ObjectRecipe(String typeName, String factoryMethod, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(typeName, factoryMethod, constructorArgNames, constructorArgTypes, null);
    }

    public ObjectRecipe(String typeName, String factoryMethod, String[] constructorArgNames, Class[] constructorArgTypes, Map<String, Object> properties) {
        this.typeName = typeName;
        this.factoryMethod = factoryMethod;
        this.constructorArgNames = constructorArgNames != null ? Arrays.asList(constructorArgNames) : null;
        List<Class> list = this.constructorArgTypes = constructorArgTypes != null ? Arrays.asList(constructorArgTypes) : null;
        if (properties != null) {
            this.setAllProperties(properties);
        }
    }

    public void allow(Option option) {
        this.options.add(option);
    }

    public void disallow(Option option) {
        this.options.remove(option);
    }

    public Set<Option> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    public List<String> getConstructorArgNames() {
        return this.constructorArgNames;
    }

    public void setConstructorArgNames(String[] constructorArgNames) {
        this.constructorArgNames = constructorArgNames != null ? Arrays.asList(constructorArgNames) : null;
    }

    public void setConstructorArgNames(List<String> constructorArgNames) {
        this.constructorArgNames = constructorArgNames;
    }

    public List<Class<?>> getConstructorArgTypes() {
        return this.constructorArgTypes;
    }

    public void setConstructorArgTypes(Class[] constructorArgTypes) {
        this.constructorArgTypes = constructorArgTypes != null ? Arrays.asList(constructorArgTypes) : null;
    }

    public void setConstructorArgTypes(List<? extends Class<?>> constructorArgTypes) {
        this.constructorArgTypes = new ArrayList(constructorArgTypes);
    }

    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    public void setFactoryMethod(String factoryMethod) {
        this.factoryMethod = factoryMethod;
    }

    public Object getProperty(String name) {
        Object value = this.properties.get(new Property(name));
        return value;
    }

    public Map<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (Map.Entry<Property, Object> entry : this.properties.entrySet()) {
            properties.put(entry.getKey().name, entry.getValue());
        }
        return properties;
    }

    public void setProperty(String name, Object value) {
        this.setProperty(new Property(name), value);
    }

    public void setFieldProperty(String name, Object value) {
        this.setProperty(new FieldProperty(name), value);
        this.options.add(Option.FIELD_INJECTION);
    }

    public void setMethodProperty(String name, Object value) {
        this.setProperty(new SetterProperty(name), value);
    }

    public void setAutoMatchProperty(String type, Object value) {
        this.setProperty(new AutoMatchProperty(type), value);
    }

    public void setCompoundProperty(String name, Object value) {
        this.setProperty(new CompoundProperty(name), value);
    }

    private void setProperty(Property key, Object value) {
        if (value instanceof UnsetPropertiesRecipe) {
            this.allow(Option.IGNORE_MISSING_PROPERTIES);
        }
        this.properties.put(key, value);
    }

    public void setAllProperties(Map<?, ?> map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            this.setProperty(name, value);
        }
    }

    public Map<String, Object> getUnsetProperties() {
        return this.unsetProperties;
    }

    public List<Recipe> getNestedRecipes() {
        ArrayList<Recipe> nestedRecipes = new ArrayList<Recipe>(this.properties.size());
        for (Object o : this.properties.values()) {
            if (!(o instanceof Recipe)) continue;
            Recipe recipe = (Recipe)o;
            nestedRecipes.add(recipe);
        }
        return nestedRecipes;
    }

    public List<Recipe> getConstructorRecipes() {
        ReflectionUtil.Factory factory = this.findFactory((Type)((Object)Object.class));
        if (this.factoryMethod != null && !(factory instanceof ReflectionUtil.StaticFactory)) {
            List parameterNames = factory.getParameterNames();
            ArrayList<Recipe> nestedRecipes = new ArrayList<Recipe>(parameterNames.size());
            for (Map.Entry<Property, Object> entry : this.properties.entrySet()) {
                if (!parameterNames.contains(entry.getKey().name) || !(entry.getValue() instanceof Recipe)) continue;
                Recipe recipe = (Recipe)entry.getValue();
                nestedRecipes.add(recipe);
            }
            return nestedRecipes;
        }
        return this.getNestedRecipes();
    }

    public boolean canCreate(Type type) {
        Class myType = this.getType();
        return RecipeHelper.isAssignable((Type)type, (Type)myType) || RecipeHelper.isAssignable((Type)type, (Type)myType);
    }

    protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
        this.unsetProperties.clear();
        Class typeClass = this.getType();
        LinkedHashMap<Property, Object> propertyValues = new LinkedHashMap<Property, Object>(this.properties);
        ReflectionUtil.Factory factory = this.findFactory(expectedType);
        Object[] parameters = this.extractConstructorArgs(propertyValues, factory);
        Object instance = factory.create(parameters);
        if (this.getName() != null) {
            ExecutionContext.getContext().addObject(this.getName(), instance);
        }
        this.setProperties(propertyValues, instance, instance.getClass());
        if (this.factoryMethod != null && !(factory instanceof ReflectionUtil.StaticFactory)) {
            Method instanceFactory = ReflectionUtil.findInstanceFactory(instance.getClass(), (String)this.factoryMethod, null);
            try {
                instance = instanceFactory.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                InvocationTargetException invocationTargetException;
                Throwable t = e;
                if (e instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)e).getCause() != null) {
                    t = invocationTargetException.getCause();
                }
                throw new ConstructionException("Error calling instance factory method: " + instanceFactory, t);
            }
        }
        return instance;
    }

    public void setProperties(Object instance) throws ConstructionException {
        this.unsetProperties.clear();
        LinkedHashMap<Property, Object> propertyValues = new LinkedHashMap<Property, Object>(this.properties);
        this.setProperties(propertyValues, instance, instance.getClass());
    }

    public Class setStaticProperties() throws ConstructionException {
        this.unsetProperties.clear();
        Class typeClass = this.getType();
        if (!Modifier.isPublic(typeClass.getModifiers())) {
            throw new ConstructionException("Class is not public: " + typeClass.getName());
        }
        if (Modifier.isInterface(typeClass.getModifiers())) {
            throw new ConstructionException("Class is an interface: " + typeClass.getName());
        }
        if (Modifier.isAbstract(typeClass.getModifiers())) {
            throw new ConstructionException("Class is abstract: " + typeClass.getName());
        }
        LinkedHashMap<Property, Object> propertyValues = new LinkedHashMap<Property, Object>(this.properties);
        this.setProperties(propertyValues, null, typeClass);
        return typeClass;
    }

    public Class getType() {
        if (this.typeClass != null || this.typeName != null) {
            Class type = this.typeClass;
            if (type == null) {
                try {
                    type = RecipeHelper.loadClass((String)this.typeName);
                }
                catch (ClassNotFoundException e) {
                    throw new ConstructionException("Type class could not be found: " + this.typeName);
                }
            }
            return type;
        }
        return null;
    }

    private void setProperties(Map<Property, Object> propertyValues, Object instance, Class clazz) {
        for (Map.Entry entry : RecipeHelper.prioritizeProperties(propertyValues)) {
            Property propertyName = (Property)entry.getKey();
            Object propertyValue = entry.getValue();
            this.setProperty(instance, clazz, propertyName, propertyValue);
        }
    }

    private void setProperty(Object instance, Class clazz, Property propertyName, Object propertyValue) {
        ArrayList<Member> members;
        block36: {
            members = new ArrayList<Member>();
            try {
                MissingAccessorException noSetter;
                block37: {
                    MethodMember member;
                    List setters;
                    if (propertyName instanceof SetterProperty) {
                        List setters2 = ReflectionUtil.findAllSetters((Class)clazz, (String)propertyName.name, (Object)propertyValue, this.options);
                        for (Method setter : setters2) {
                            MethodMember member2 = new MethodMember(setter);
                            members.add(member2);
                        }
                        break block36;
                    }
                    if (propertyName instanceof FieldProperty) {
                        FieldMember member3 = new FieldMember(ReflectionUtil.findField((Class)clazz, (String)propertyName.name, (Object)propertyValue, this.options));
                        members.add(member3);
                        break block36;
                    }
                    if (propertyName instanceof AutoMatchProperty) {
                        List settersByType;
                        ArrayList<String> matches;
                        Member member4;
                        MissingAccessorException noField = null;
                        if (this.options.contains(Option.FIELD_INJECTION)) {
                            List fieldsByType = null;
                            try {
                                fieldsByType = ReflectionUtil.findAllFieldsByType((Class)clazz, (Object)propertyValue, this.options);
                                member4 = new FieldMember((Field)fieldsByType.iterator().next());
                                members.add(member4);
                            }
                            catch (MissingAccessorException e) {
                                noField = e;
                            }
                            if (fieldsByType != null && fieldsByType.size() > 1) {
                                matches = new ArrayList<String>();
                                for (Field field : fieldsByType) {
                                    matches.add(field.getName());
                                }
                                throw new MissingAccessorException("Property of " + propertyValue + " can be mapped to more then one field: " + matches + " of " + clazz, 0);
                            }
                        }
                        if (!members.isEmpty()) break block36;
                        try {
                            settersByType = ReflectionUtil.findAllSettersByType((Class)clazz, (Object)propertyValue, this.options);
                            member4 = new MethodMember((Method)settersByType.iterator().next());
                            members.add(member4);
                        }
                        catch (MissingAccessorException noSetter2) {
                            throw noField == null || noSetter2.getMatchLevel() > noField.getMatchLevel() ? noSetter2 : noField;
                        }
                        if (settersByType != null && settersByType.size() > 1) {
                            matches = new ArrayList();
                            for (Method setter : settersByType) {
                                matches.add(setter.getName());
                            }
                            throw new MissingAccessorException("Property of " + propertyValue + " can be mapped to more then one setter: " + matches, 0);
                        }
                        break block36;
                    }
                    if (propertyName instanceof CompoundProperty) {
                        String[] names = propertyName.name.split("\\.");
                        for (int i = 0; i < names.length - 1; ++i) {
                            Method getter = ReflectionUtil.findGetter((Class)clazz, (String)names[i], this.options);
                            if (getter != null) {
                                try {
                                    instance = getter.invoke(instance, new Object[0]);
                                    clazz = instance.getClass();
                                    continue;
                                }
                                catch (Exception e) {
                                    InvocationTargetException invocationTargetException;
                                    Throwable t = e;
                                    if (e instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)e).getCause() != null) {
                                        t = invocationTargetException.getCause();
                                    }
                                    throw new ConstructionException("Error setting property: " + names[i], t);
                                }
                            }
                            throw new ConstructionException("No getter for " + names[i] + " property");
                        }
                        setters = ReflectionUtil.findAllSetters((Class)clazz, (String)names[names.length - 1], (Object)propertyValue, this.options);
                        for (Method setter : setters) {
                            member = new MethodMember(setter);
                            members.add(member);
                        }
                        break block36;
                    }
                    noSetter = null;
                    try {
                        setters = ReflectionUtil.findAllSetters((Class)clazz, (String)propertyName.name, (Object)propertyValue, this.options);
                        for (Method setter : setters) {
                            member = new MethodMember(setter);
                            members.add(member);
                        }
                    }
                    catch (MissingAccessorException e) {
                        noSetter = e;
                        if (this.options.contains(Option.FIELD_INJECTION)) break block37;
                        throw noSetter;
                    }
                }
                if (!this.options.contains(Option.FIELD_INJECTION)) break block36;
                try {
                    FieldMember member = new FieldMember(ReflectionUtil.findField((Class)clazz, (String)propertyName.name, (Object)propertyValue, this.options));
                    members.add(member);
                }
                catch (MissingAccessorException noField) {
                    if (members.isEmpty()) {
                        throw noSetter == null || noField.getMatchLevel() > noSetter.getMatchLevel() ? noField : noSetter;
                    }
                }
            }
            catch (MissingAccessorException e) {
                if (this.options.contains(Option.IGNORE_MISSING_PROPERTIES)) {
                    this.unsetProperties.put(propertyName.name, propertyValue);
                    return;
                }
                throw e;
            }
        }
        ConstructionException conversionException = null;
        for (Member member4 : members) {
            try {
                propertyValue = RecipeHelper.convert((Type)member4.getType(), (Object)propertyValue, (boolean)false);
            }
            catch (ConstructionException e) {
                if (conversionException != null) continue;
                conversionException = e;
                continue;
            }
            catch (Exception e) {
                if (conversionException != null) continue;
                String valueType = propertyValue == null ? "null" : propertyValue.toString();
                String memberType = member4.getType() instanceof Class ? ((Class)member4.getType()).getName() : member4.getType().toString();
                conversionException = new ConstructionException("Unable to convert property value from " + valueType + " to " + memberType + " for injection " + member4, (Throwable)e);
                continue;
            }
            try {
                member4.setValue(instance, propertyValue);
            }
            catch (Exception e) {
                InvocationTargetException invocationTargetException;
                Throwable t = e;
                if (e instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)e).getCause() != null) {
                    t = invocationTargetException.getCause();
                }
                throw new ConstructionException("Error setting property: " + member4, t);
            }
            return;
        }
        throw conversionException;
    }

    private ReflectionUtil.Factory findFactory(Type expectedType) {
        Class type = this.getType();
        if (this.factoryMethod != null) {
            try {
                ReflectionUtil.StaticFactory staticFactory = ReflectionUtil.findStaticFactory((Class)type, (String)this.factoryMethod, this.constructorArgNames, this.constructorArgTypes, this.getProperties().keySet(), this.options);
                return staticFactory;
            }
            catch (MissingFactoryMethodException ignored) {
                // empty catch block
            }
        }
        Class consturctorClass = RecipeHelper.isAssignable((Type)type, (Type)expectedType) ? RecipeHelper.toClass((Type)expectedType) : type;
        ReflectionUtil.ConstructorFactory constructor = ReflectionUtil.findConstructor((Class)consturctorClass, this.constructorArgNames, this.constructorArgTypes, this.getProperties().keySet(), this.options);
        return constructor;
    }

    private Object[] extractConstructorArgs(Map propertyValues, ReflectionUtil.Factory factory) {
        List parameterNames = factory.getParameterNames();
        List parameterTypes = factory.getParameterTypes();
        Object[] parameters = new Object[parameterNames.size()];
        for (int i = 0; i < parameterNames.size(); ++i) {
            Object value;
            Property name = new Property((String)parameterNames.get(i));
            Type type = (Type)parameterTypes.get(i);
            if (propertyValues.containsKey(name)) {
                value = propertyValues.remove(name);
                if (!RecipeHelper.isInstance((Type)type, value) && !RecipeHelper.isConvertable((Type)type, value)) {
                    throw new ConstructionException("Invalid and non-convertable constructor parameter type: name=" + name + ", " + "index=" + i + ", " + "expected=" + RecipeHelper.toClass((Type)type).getName() + ", " + "actual=" + (value == null ? "null" : value.toString()));
                }
                value = RecipeHelper.convert((Type)type, value, (boolean)false);
            } else {
                value = ObjectRecipe.getDefaultValue(RecipeHelper.toClass((Type)type));
            }
            parameters[i] = value;
        }
        return parameters;
    }

    private static Object getDefaultValue(Class type) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.FALSE;
        }
        if (type.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        if (type.equals(Byte.TYPE)) {
            return (byte)0;
        }
        if (type.equals(Short.TYPE)) {
            return (short)0;
        }
        if (type.equals(Integer.TYPE)) {
            return 0;
        }
        if (type.equals(Long.TYPE)) {
            return 0L;
        }
        if (type.equals(Float.TYPE)) {
            return Float.valueOf(0.0f);
        }
        if (type.equals(Double.TYPE)) {
            return 0.0;
        }
        return null;
    }

    public static class CompoundProperty
    extends Property {
        public CompoundProperty(String type) {
            super(type);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 1;
        }

        @Override
        public String toString() {
            return "[compound] " + super.toString();
        }
    }

    public static class AutoMatchProperty
    extends Property {
        public AutoMatchProperty(String type) {
            super(type);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 1;
        }

        @Override
        public String toString() {
            return "[auto-match] " + super.toString();
        }
    }

    public static class FieldProperty
    extends Property {
        public FieldProperty(String name) {
            super(name);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 1;
        }

        @Override
        public String toString() {
            return "[field] " + super.toString();
        }
    }

    public static class SetterProperty
    extends Property {
        public SetterProperty(String name) {
            super(name);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 2;
        }

        @Override
        public String toString() {
            return "[setter] " + super.toString();
        }
    }

    public static class Property {
        private final String name;

        public Property(String name) {
            if (name == null) {
                throw new NullPointerException("name is null");
            }
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof String) {
                return this.name.equals(o);
            }
            if (o instanceof Property) {
                Property property = (Property)o;
                return this.name.equals(property.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class FieldMember
    implements Member {
        private final Field field;

        public FieldMember(Field field) {
            this.field = field;
        }

        @Override
        public Type getType() {
            return this.field.getGenericType();
        }

        @Override
        public void setValue(Object instance, Object value) throws Exception {
            this.field.set(instance, value);
        }

        public String toString() {
            return this.field.toString();
        }
    }

    public static class MethodMember
    implements Member {
        private final Method setter;

        public MethodMember(Method method) {
            this.setter = method;
        }

        @Override
        public Type getType() {
            return this.setter.getGenericParameterTypes()[0];
        }

        @Override
        public void setValue(Object instance, Object value) throws Exception {
            this.setter.invoke(instance, value);
        }

        public String toString() {
            return this.setter.toString();
        }
    }

    public static interface Member {
        public Type getType();

        public void setValue(Object var1, Object var2) throws Exception;
    }
}

