/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.converter.basic;

import java.lang.reflect.Type;
import org.unidal.converter.Converter;
import org.unidal.converter.ConverterException;
import org.unidal.converter.TypeUtil;

public class ShortConverter
implements Converter<Short> {
    @Override
    public boolean canConvert(Type fromType, Type targetType) {
        return TypeUtil.isTypeSupported(fromType, new Type[]{Number.class, Boolean.TYPE, Boolean.class, String.class, Enum.class});
    }

    @Override
    public Short convert(Object from, Type targetType) throws ConverterException {
        if (from instanceof Number) {
            return ((Number)from).shortValue();
        }
        if (from instanceof Boolean) {
            return (Boolean)from != false ? (short)1 : 0;
        }
        if (from instanceof Enum) {
            return (short)((Enum)from).ordinal();
        }
        try {
            return Short.valueOf(from.toString());
        }
        catch (NumberFormatException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public Type getTargetType() {
        return Short.class;
    }
}

