/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.logger;

import java.io.File;
import java.net.URL;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.codehaus.plexus.logging.AbstractLogger;
import org.codehaus.plexus.logging.BaseLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.unidal.helper.Properties;

public class Log4jLoggerManager
extends BaseLoggerManager {
    private String m_configurationFile = "log4j.xml";
    private String m_baseDirRef;

    protected Logger createLogger(String name) {
        org.apache.log4j.Logger logger = LogManager.getLogger((String)name);
        LevelAdapter level = new LevelAdapter(logger.getLevel());
        return new LoggerAdapter(logger, level.getThreshold());
    }

    public void initialize() {
        super.initialize();
        String baseDir = Properties.forString().fromSystem().fromEnv().getProperty(this.m_baseDirRef, null);
        boolean loaded = false;
        if (baseDir != null) {
            loaded = this.tryLoadingFromFile(baseDir);
        }
        if (!loaded) {
            loaded = this.tryLoadingFromResource();
        }
        if (!loaded) {
            LogManager.getLogger((String)((Object)((Object)this)).getClass().getName()).warn((Object)String.format("No configuration(%s) was found with baseDirRef(%s)!", this.m_configurationFile, this.m_baseDirRef));
        }
    }

    public void setBaseDirRef(String baseDirRef) {
        this.m_baseDirRef = baseDirRef;
    }

    public void setConfigurationFile(String configurationFile) {
        this.m_configurationFile = configurationFile;
    }

    protected String toMapKey(String role, String roleHint) {
        return role;
    }

    private boolean tryLoadingFromFile(String baseDir) throws FactoryConfigurationError {
        File file;
        if (this.m_configurationFile.endsWith(".xml")) {
            File file2 = new File(baseDir, this.m_configurationFile);
            if (file2.exists()) {
                DOMConfigurator.configure((String)file2.getAbsolutePath());
                return true;
            }
        } else if (this.m_configurationFile.endsWith(".properties") && (file = new File(baseDir, this.m_configurationFile)).exists()) {
            PropertyConfigurator.configure((String)file.getAbsolutePath());
            return true;
        }
        return false;
    }

    private boolean tryLoadingFromResource() throws FactoryConfigurationError {
        URL url;
        if (this.m_configurationFile.endsWith(".xml")) {
            URL url2 = ((Object)((Object)this)).getClass().getResource(this.m_configurationFile);
            if (url2 != null) {
                DOMConfigurator.configure((URL)url2);
                return true;
            }
        } else if (this.m_configurationFile.endsWith(".properties") && (url = ((Object)((Object)this)).getClass().getResource(this.m_configurationFile)) != null) {
            PropertyConfigurator.configure((URL)url);
            return true;
        }
        return false;
    }

    static class LoggerAdapter
    extends AbstractLogger {
        private org.apache.log4j.Logger m_logger;

        public LoggerAdapter(org.apache.log4j.Logger logger, int threshold) {
            super(threshold, logger.getName());
            this.m_logger = logger;
        }

        public void debug(String message, Throwable t) {
            if (this.isDebugEnabled()) {
                this.m_logger.debug((Object)message, t);
            }
        }

        public void error(String message, Throwable t) {
            if (this.isErrorEnabled()) {
                this.m_logger.error((Object)message, t);
            }
        }

        public void fatalError(String message, Throwable t) {
            if (this.isFatalErrorEnabled()) {
                this.m_logger.fatal((Object)message, t);
            }
        }

        public Logger getChildLogger(String name) {
            return this;
        }

        public void info(String message, Throwable t) {
            if (this.isInfoEnabled()) {
                this.m_logger.info((Object)message, t);
            }
        }

        public void warn(String message, Throwable t) {
            if (this.isWarnEnabled()) {
                this.m_logger.warn((Object)message, t);
            }
        }
    }

    static class LevelAdapter {
        private int m_threshold = 0;

        public LevelAdapter(Level level) {
            if (level != null) {
                switch (level.toInt()) {
                    case 10000: {
                        this.m_threshold = 0;
                        break;
                    }
                    case 20000: {
                        this.m_threshold = 1;
                        break;
                    }
                    case 30000: {
                        this.m_threshold = 2;
                        break;
                    }
                    case 40000: {
                        this.m_threshold = 3;
                        break;
                    }
                    case 50000: {
                        this.m_threshold = 4;
                    }
                }
            }
        }

        public int getThreshold() {
            return this.m_threshold;
        }
    }
}

