/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.monitor.sdk.push.impl;

import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.gaga.monitor.sdk.model.LogMessage;
import plus.gaga.monitor.sdk.push.IPush;

public class RedisPush
implements IPush {
    private final Logger logger = LoggerFactory.getLogger(RedisPush.class);
    private RedissonClient redissonClient;

    @Override
    public synchronized void open(String host, int port) {
        if (null != this.redissonClient && !this.redissonClient.isShutdown()) {
            return;
        }
        Config config = new Config();
        config.setCodec((Codec)JsonJacksonCodec.INSTANCE);
        ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress("redis://" + host + ":" + port).setConnectionPoolSize(64).setConnectionMinimumIdleSize(10).setIdleConnectionTimeout(1000)).setConnectTimeout(1000)).setRetryAttempts(3)).setRetryInterval(1000)).setPingConnectionInterval(0)).setKeepAlive(true);
        this.logger.info("\u4e1a\u52a1\u76d1\u63a7\u542f\u52a8\u542f\u52a8\u5b8c\u6210 By business-behavior-monitor-sdk xiaofuge");
        this.redissonClient = Redisson.create((Config)config);
    }

    @Override
    public void send(LogMessage logMessage) {
        try {
            RTopic topic = this.redissonClient.getTopic("business-behavior-monitor-sdk-topic");
            topic.publish((Object)logMessage);
        }
        catch (Exception e) {
            this.logger.error("\u8b66\u544a\uff1a\u4e1a\u52a1\u884c\u4e3a\u76d1\u63a7\u7ec4\u4ef6\uff0c\u63a8\u9001\u65e5\u5fd7\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

