/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.spring.autoconfiguration;

import cloud.tianai.captcha.application.ImageCaptchaApplication;
import cloud.tianai.captcha.application.ImageCaptchaProperties;
import cloud.tianai.captcha.application.TACBuilder;
import cloud.tianai.captcha.cache.CacheStore;
import cloud.tianai.captcha.common.util.CollectionUtils;
import cloud.tianai.captcha.generator.ImageCaptchaGenerator;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.impl.transform.Base64ImageTransform;
import cloud.tianai.captcha.interceptor.CaptchaInterceptor;
import cloud.tianai.captcha.interceptor.CaptchaInterceptorGroup;
import cloud.tianai.captcha.interceptor.impl.ParamCheckCaptchaInterceptor;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceProviders;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.impl.DefaultImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.impl.LocalMemoryResourceStore;
import cloud.tianai.captcha.spring.autoconfiguration.CacheStoreAutoConfiguration;
import cloud.tianai.captcha.spring.autoconfiguration.SpringImageCaptchaProperties;
import cloud.tianai.captcha.spring.plugins.SpringMultiImageCaptchaGenerator;
import cloud.tianai.captcha.spring.plugins.secondary.SecondaryVerificationApplication;
import cloud.tianai.captcha.validator.ImageCaptchaValidator;
import cloud.tianai.captcha.validator.impl.SimpleImageCaptchaValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.Order;

@Order
@Configuration
@AutoConfigureAfter(value={CacheStoreAutoConfiguration.class})
@EnableConfigurationProperties(value={SpringImageCaptchaProperties.class})
public class ImageCaptchaAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ImageCaptchaAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public ResourceStore resourceStore() {
        return new LocalMemoryResourceStore();
    }

    @Bean
    @ConditionalOnMissingBean
    public ImageCaptchaResourceManager imageCaptchaResourceManager(ResourceStore resourceStore) {
        ResourceProviders resourceProviders = new ResourceProviders();
        return new DefaultImageCaptchaResourceManager(resourceStore, resourceProviders);
    }

    @Bean
    @ConditionalOnMissingBean
    public ImageTransform imageTransform() {
        return new Base64ImageTransform();
    }

    @Bean
    @ConditionalOnMissingBean
    public ImageCaptchaGenerator imageCaptchaTemplate(SpringImageCaptchaProperties prop, ImageCaptchaResourceManager captchaResourceManager, ImageTransform imageTransform, BeanFactory beanFactory) {
        return new SpringMultiImageCaptchaGenerator(captchaResourceManager, imageTransform, beanFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public ImageCaptchaValidator imageCaptchaValidator() {
        return new SimpleImageCaptchaValidator();
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean
    public CaptchaInterceptor captchaInterceptor() {
        CaptchaInterceptorGroup group = new CaptchaInterceptorGroup();
        group.addInterceptor((CaptchaInterceptor)new ParamCheckCaptchaInterceptor());
        return group;
    }

    @Bean
    @ConditionalOnMissingBean
    public ImageCaptchaApplication imageCaptchaApplication(ImageCaptchaGenerator captchaGenerator, ImageCaptchaValidator imageCaptchaValidator, CacheStore cacheStore, ResourceStore resourceStore, SpringImageCaptchaProperties prop, CaptchaInterceptor captchaInterceptor, ApplicationContext applicationContext) {
        TACBuilder tacBuilder = TACBuilder.builder((ResourceStore)resourceStore).setGenerator(captchaGenerator).setValidator(imageCaptchaValidator).setCacheStore(cacheStore).setProp((ImageCaptchaProperties)prop).setInterceptor(captchaInterceptor);
        if (prop.getInitDefaultResource().booleanValue()) {
            tacBuilder.addDefaultTemplate(prop.getDefaultResourcePrefix());
        }
        if (!CollectionUtils.isEmpty(prop.getFontPath())) {
            for (String fontPath : prop.getFontPath()) {
                String[] stringArray;
                int index = fontPath.indexOf(":");
                if (index > 0) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = fontPath.substring(0, index);
                    stringArray = stringArray2;
                    stringArray2[1] = fontPath.substring(index + 1);
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = "";
                    stringArray = stringArray3;
                    stringArray3[1] = fontPath;
                }
                String[] split = stringArray;
                String type = split[0];
                String path = split[1];
                tacBuilder.addFont(new Resource(type, path));
            }
        }
        Object target = tacBuilder.build();
        if (prop.getSecondary() != null && Boolean.TRUE.equals(prop.getSecondary().getEnabled())) {
            target = new SecondaryVerificationApplication((ImageCaptchaApplication)target, prop.getSecondary());
        }
        return target;
    }
}

