/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.pdf.export;

import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.export.base.ExportCommonService;
import cn.afterturn.easypoi.pdf.entity.PdfExportParams;
import cn.afterturn.easypoi.pdf.styler.IPdfExportStyler;
import cn.afterturn.easypoi.pdf.styler.PdfExportStylerDefaultImpl;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.BorderStyle;
import org.vandeseer.easytable.settings.BorderStyleInterface;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;

public class PdfExportServer
extends ExportCommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfExportServer.class);
    private PDDocument document;
    private IPdfExportStyler styler = new PdfExportStylerDefaultImpl();
    private boolean isListData = false;

    public PdfExportServer(PdfExportParams entity) {
        try {
            this.styler = entity.getStyler() == null ? this.styler : entity.getStyler();
            this.document = new PDDocument();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public PdfExportServer() {
    }

    public PDDocument createPdf(PdfExportParams entity, Class<?> pojoClass, Collection<?> dataSet) {
        try {
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                // empty if block
            }
            Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
            ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
            String targetId = etarget == null ? null : etarget.value();
            this.getAllExcelField(entity.getExclusions(), targetId, fileds, excelParams, pojoClass, null, null);
            this.createPdfByExportEntity(entity, excelParams, dataSet);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return this.document;
    }

    public PDDocument createPdfByExportEntity(PdfExportParams entity, List<ExcelExportEntity> excelParams, Collection<?> dataSet) {
        try {
            this.sortAllParams(excelParams);
            int paramSize = excelParams.size();
            for (int k = 0; k < paramSize; ++k) {
                if (excelParams.get(k).getList() == null) continue;
                this.isListData = true;
                break;
            }
            PDPage page = new PDPage(entity.getPageSize());
            this.document.addPage(page);
            PDPageContentStream contentStream = new PDPageContentStream(this.document, page);
            PDType0Font font = PDType0Font.load((PDDocument)this.document, (File)new File("C:\\Windows\\Fonts\\simfang.ttf"));
            contentStream.setFont((PDFont)font, 12.0f);
            Table.TableBuilder table = Table.builder().font((PDFont)font);
            float[] width = this.getCellWidths(table, excelParams);
            this.createHeaderAndTitle(table, entity, excelParams, width.length);
            int rowHeight = this.getRowHeight(excelParams) / 50;
            for (Object t : dataSet) {
                this.createCells(table, t, excelParams, rowHeight);
            }
            TableDrawer.builder().contentStream(contentStream).startX(20.0f).startY(page.getMediaBox().getUpperRightY() - 20.0f).table(table.build()).build().draw();
            contentStream.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return this.document;
    }

    private void createCells(Table.TableBuilder table, Object t, List<ExcelExportEntity> excelParams, int rowHeight) throws Exception {
        int maxHeight = this.getThisMaxHeight(t, excelParams);
        Row.RowBuilder row = Row.builder();
        int paramSize = excelParams.size();
        for (int k = 0; k < paramSize; ++k) {
            ExcelExportEntity entity = excelParams.get(k);
            if (entity.getList() != null) {
                Collection<?> list = this.getListCellValue(entity, t);
                boolean i = false;
                for (Object obj : list) {
                    if (!i) {
                        this.createListCells(row, obj, entity.getList(), rowHeight);
                        continue;
                    }
                    Row.RowBuilder listRow = Row.builder();
                    this.createListCells(listRow, obj, entity.getList(), rowHeight);
                    table.addRow(listRow.build());
                }
                continue;
            }
            Object value = this.getCellValue(entity, t);
            if (entity.getType() != 1) continue;
            this.createStringCell(row, value == null ? "" : value.toString(), entity, rowHeight, 1, maxHeight);
        }
        table.addRow(row.build());
    }

    private void createListCells(Row.RowBuilder row, Object obj, List<ExcelExportEntity> excelParams, int rowHeight) throws Exception {
        int paramSize = excelParams.size();
        for (int k = 0; k < paramSize; ++k) {
            ExcelExportEntity entity = excelParams.get(k);
            Object value = this.getCellValue(entity, obj);
            if (entity.getType() != 1) continue;
            this.createStringCell(row, value == null ? "" : value.toString(), entity, rowHeight);
        }
    }

    private int getThisMaxHeight(Object t, List<ExcelExportEntity> excelParams) throws Exception {
        if (this.isListData) {
            int maxHeight = 1;
            int paramSize = excelParams.size();
            for (int k = 0; k < paramSize; ++k) {
                ExcelExportEntity entity = excelParams.get(k);
                if (entity.getList() == null) continue;
                Collection<?> list = this.getListCellValue(entity, t);
                maxHeight = list == null || maxHeight > list.size() ? maxHeight : list.size();
            }
            return maxHeight;
        }
        return 1;
    }

    private float[] getCellWidths(Table.TableBuilder table, List<ExcelExportEntity> excelParams) {
        ArrayList<Float> widths = new ArrayList<Float>();
        for (int i = 0; i < excelParams.size(); ++i) {
            if (excelParams.get(i).getList() != null) {
                List<ExcelExportEntity> list = excelParams.get(i).getList();
                for (int j = 0; j < list.size(); ++j) {
                    widths.add(Float.valueOf((float)(8.0 * list.get(j).getWidth())));
                }
                continue;
            }
            widths.add(Float.valueOf((float)(8.0 * excelParams.get(i).getWidth())));
        }
        float[] widthArr = new float[widths.size()];
        for (int i = 0; i < widthArr.length; ++i) {
            table.addColumnOfWidth(((Float)widths.get(i)).floatValue());
        }
        return widthArr;
    }

    private void createHeaderAndTitle(Table.TableBuilder table, PdfExportParams entity, List<ExcelExportEntity> excelParams, int colspan) {
        if (entity.getTitle() != null) {
            this.createTitleRow(entity, table, colspan);
        }
        this.createHeaderRow(entity, table, excelParams);
    }

    private int createHeaderRow(PdfExportParams title, Table.TableBuilder table, List<ExcelExportEntity> excelParams) {
        int rows = this.getRowNums(excelParams, false);
        Row.RowBuilder row = Row.builder();
        int exportFieldTitleSize = excelParams.size();
        for (int i = 0; i < exportFieldTitleSize; ++i) {
            ExcelExportEntity entity = excelParams.get(i);
            if (entity.getList() != null) {
                if (StringUtils.isNotBlank((CharSequence)entity.getName())) {
                    this.createStringCell(row, entity.getName(), entity, 10, entity.getList().size(), 1);
                }
                Row.RowBuilder listRow = Row.builder();
                List<ExcelExportEntity> sTitel = entity.getList();
                int size = sTitel.size();
                for (int j = 0; j < size; ++j) {
                    this.createStringCell(listRow, sTitel.get(j).getName(), sTitel.get(j), 10);
                }
                table.addRow(listRow.build());
                continue;
            }
            this.createStringCell(row, entity.getName(), entity, 10, 1, rows == 2 ? 2 : 1);
        }
        table.addRow(row.build());
        return rows;
    }

    private void createTitleRow(PdfExportParams entity, Table.TableBuilder table, int colspan) {
        table.addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(entity.getTitle()).verticalAlignment(VerticalAlignment.MIDDLE)).horizontalAlignment(HorizontalAlignment.CENTER)).textHeight(Float.valueOf(entity.getTitleHeight()))).fontSize(Integer.valueOf(entity.getTitleHeight() - 10))).borderColor(Color.BLACK)).borderWidth(1.0f)).borderStyle((BorderStyleInterface)BorderStyle.SOLID)).colSpan(colspan)).build()).build());
        if (entity.getSecondTitle() != null) {
            table.addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(entity.getSecondTitle()).verticalAlignment(VerticalAlignment.MIDDLE)).horizontalAlignment(HorizontalAlignment.CENTER)).textHeight(Float.valueOf(entity.getTitleHeight()))).fontSize(Integer.valueOf(entity.getTitleHeight() - 10))).borderColor(Color.BLACK)).borderWidth(1.0f)).borderStyle((BorderStyleInterface)BorderStyle.SOLID)).colSpan(colspan)).build()).build());
        }
    }

    private TextCell.TextCellBuilder createStringCell(Row.RowBuilder row, String text, ExcelExportEntity entity, int rowHeight, int colspan, int rowspan) {
        TextCell.TextCellBuilder cell = (TextCell.TextCellBuilder)TextCell.builder().text(text).textHeight(Float.valueOf((float)((double)rowHeight * 2.5)));
        cell.rowSpan(rowspan).colSpan(colspan);
        this.styler.setCellStyler(cell, entity, text);
        row.add((AbstractCell)cell.build());
        return cell;
    }

    private TextCell.TextCellBuilder createStringCell(Row.RowBuilder row, String text, ExcelExportEntity entity, int rowHeight) {
        TextCell.TextCellBuilder cell = (TextCell.TextCellBuilder)TextCell.builder().text(text).textHeight(Float.valueOf((float)((double)rowHeight * 2.5)));
        this.styler.setCellStyler(cell, entity, text);
        row.add((AbstractCell)cell.build());
        return cell;
    }
}

