/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.wrench.design.framework.link.model2.chain;

import cn.bugstack.wrench.design.framework.link.model2.chain.ILink;

public class LinkedList<E>
implements ILink<E> {
    private final String name;
    transient int size = 0;
    transient Node<E> first;
    transient Node<E> last;

    public LinkedList(String name) {
        this.name = name;
    }

    void linkFirst(E e) {
        Node<E> f = this.first;
        Node<E> newNode = new Node<E>(null, e, f);
        this.first = newNode;
        if (f == null) {
            this.last = newNode;
        } else {
            f.prev = newNode;
        }
        ++this.size;
    }

    void linkLast(E e) {
        Node<E> l = this.last;
        Node<E> newNode = new Node<E>(l, e, null);
        this.last = newNode;
        if (l == null) {
            this.first = newNode;
        } else {
            l.next = newNode;
        }
        ++this.size;
    }

    @Override
    public boolean add(E e) {
        this.linkLast(e);
        return true;
    }

    @Override
    public boolean addFirst(E e) {
        this.linkFirst(e);
        return true;
    }

    @Override
    public boolean addLast(E e) {
        this.linkLast(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            Node<E> x = this.first;
            while (x != null) {
                if (x.item == null) {
                    this.unlink(x);
                    return true;
                }
                x = x.next;
            }
        } else {
            Node<E> x = this.first;
            while (x != null) {
                if (o.equals(x.item)) {
                    this.unlink(x);
                    return true;
                }
                x = x.next;
            }
        }
        return false;
    }

    E unlink(Node<E> x) {
        Object element = x.item;
        Node next = x.next;
        Node prev = x.prev;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
            x.prev = null;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
            x.next = null;
        }
        x.item = null;
        --this.size;
        return element;
    }

    @Override
    public E get(int index) {
        return this.node((int)index).item;
    }

    Node<E> node(int index) {
        if (index < this.size >> 1) {
            Node<E> x = this.first;
            for (int i2 = 0; i2 < index; ++i2) {
                x = x.next;
            }
            return x;
        }
        Node<E> x = this.last;
        for (int i3 = this.size - 1; i3 > index; --i3) {
            x = x.prev;
        }
        return x;
    }

    @Override
    public void printLinkList() {
        if (this.size == 0) {
            System.out.println("\u94fe\u8868\u4e3a\u7a7a");
        } else {
            Node<E> temp = this.first;
            System.out.print("\u76ee\u524d\u7684\u5217\u8868\uff0c\u5934\u8282\u70b9\uff1a" + this.first.item + " \u5c3e\u8282\u70b9\uff1a" + this.last.item + " \u6574\u4f53\uff1a");
            while (temp != null) {
                System.out.print(temp.item + "\uff0c");
                temp = temp.next;
            }
            System.out.println();
        }
    }

    public String getName() {
        return this.name;
    }

    protected static class Node<E> {
        E item;
        Node<E> next;
        Node<E> prev;

        public Node(Node<E> prev, E element, Node<E> next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }
    }
}

