/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.wrench.dynamic.config.center.config;

import cn.bugstack.wrench.dynamic.config.center.config.DynamicConfigCenterAutoProperties;
import cn.bugstack.wrench.dynamic.config.center.config.DynamicConfigCenterRegisterAutoProperties;
import cn.bugstack.wrench.dynamic.config.center.domain.model.valobj.AttributeVO;
import cn.bugstack.wrench.dynamic.config.center.domain.service.DynamicConfigCenterService;
import cn.bugstack.wrench.dynamic.config.center.domain.service.IDynamicConfigCenterService;
import cn.bugstack.wrench.dynamic.config.center.listener.DynamicConfigCenterAdjustListener;
import cn.bugstack.wrench.dynamic.config.center.types.common.Constants;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={DynamicConfigCenterAutoProperties.class, DynamicConfigCenterRegisterAutoProperties.class})
public class DynamicConfigCenterRegisterAutoConfig {
    private final Logger log = LoggerFactory.getLogger(DynamicConfigCenterRegisterAutoConfig.class);

    @Bean(value={"xfgWrenchRedissonClient"})
    public RedissonClient redissonClient(DynamicConfigCenterRegisterAutoProperties properties) {
        Config config = new Config();
        config.setCodec(JsonJacksonCodec.INSTANCE);
        ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress("redis://" + properties.getHost() + ":" + properties.getPort()).setPassword(properties.getPassword())).setConnectionPoolSize(properties.getPoolSize()).setConnectionMinimumIdleSize(properties.getMinIdleSize()).setIdleConnectionTimeout(properties.getIdleTimeout())).setConnectTimeout(properties.getConnectTimeout())).setRetryAttempts(properties.getRetryAttempts())).setRetryInterval(properties.getRetryInterval())).setPingConnectionInterval(properties.getPingInterval())).setKeepAlive(properties.isKeepAlive());
        RedissonClient redissonClient = Redisson.create(config);
        this.log.info("xfg-wrench\uff0c\u6ce8\u518c\u5668\uff08redis\uff09\u94fe\u63a5\u521d\u59cb\u5316\u5b8c\u6210\u3002{} {} {}", properties.getHost(), properties.getPoolSize(), !redissonClient.isShutdown());
        return redissonClient;
    }

    @Bean
    public IDynamicConfigCenterService dynamicConfigCenterService(DynamicConfigCenterAutoProperties dynamicConfigCenterAutoProperties, RedissonClient xfgWrenchRedissonClient) {
        return new DynamicConfigCenterService(dynamicConfigCenterAutoProperties, xfgWrenchRedissonClient);
    }

    @Bean
    public DynamicConfigCenterAdjustListener dynamicConfigCenterAdjustListener(IDynamicConfigCenterService dynamicConfigCenterService) {
        return new DynamicConfigCenterAdjustListener(dynamicConfigCenterService);
    }

    @Bean(name={"dynamicConfigCenterRedisTopic"})
    public RTopic threadPoolConfigAdjustListener(DynamicConfigCenterAutoProperties dynamicConfigCenterAutoProperties, RedissonClient redissonClient, DynamicConfigCenterAdjustListener dynamicConfigCenterAdjustListener) {
        RTopic topic = redissonClient.getTopic(Constants.getTopic(dynamicConfigCenterAutoProperties.getSystem()));
        topic.addListener(AttributeVO.class, dynamicConfigCenterAdjustListener);
        return topic;
    }
}

