/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.redission;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class JSONBCodec
extends BaseCodec {
    final JSONEncoder encoder;
    final JSONDecoder decoder;

    public JSONBCodec(Type valueType) {
        this(JSONFactory.createWriteContext(), JSONFactory.createReadContext(), valueType);
    }

    public JSONBCodec(JSONWriter.Context writerContext, JSONReader.Context readerContext) {
        this(writerContext, readerContext, null);
    }

    public JSONBCodec(JSONWriter.Context writerContext, JSONReader.Context readerContext, Type valueType) {
        this(new JSONEncoder(writerContext), new JSONDecoder(readerContext, valueType));
    }

    public JSONBCodec(JSONEncoder encoder, JSONDecoder decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    public static class JSONEncoder
    implements Encoder {
        final JSONWriter.Context context;

        public JSONEncoder(JSONWriter.Context context) {
            this.context = context;
        }

        @Override
        public ByteBuf encode(Object object) throws IOException {
            JSONWriter writer = JSONWriter.ofJSONB(this.context);
            try {
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    Class<?> valueClass = object.getClass();
                    if (valueClass == JSONObject.class && this.context.getFeatures() == 0L) {
                        writer.write((JSONObject)object);
                    } else {
                        ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
                        objectWriter.write(writer, object, null, null, 0L);
                    }
                }
                int size = writer.size();
                ByteBuf out = ByteBufAllocator.DEFAULT.buffer(size);
                ByteBufOutputStream baos = new ByteBufOutputStream(out);
                writer.flushTo(baos);
                ByteBuf byteBuf = baos.buffer();
                if (writer != null) {
                    writer.close();
                }
                return byteBuf;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new JSONException("JSON#toJSONString cannot serialize '" + object + "'", e);
                }
            }
        }
    }

    public static class JSONDecoder
    implements Decoder<Object> {
        final JSONReader.Context context;
        final Type valueType;

        public JSONDecoder(JSONReader.Context context, Type valueType) {
            this.context = context;
            this.valueType = valueType;
        }

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            Object value;
            try (JSONReader jsonReader = JSONReader.ofJSONB(new ByteBufInputStream(buf), this.context);){
                value = this.valueType == null || this.valueType == Object.class ? jsonReader.readAny() : jsonReader.read(this.valueType);
            }
            return value;
        }
    }
}

